/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.terasology.gestalt.assets.ResolutionStrategy;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.management.ContextManager;
import org.terasology.gestalt.assets.module.ModuleDependencyResolutionStrategy;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.module.ModuleEnvironment;
import org.terasology.gestalt.naming.Name;

public class ComponentTypeIndex {
    private transient Map<ResourceUrn, Class<? extends Component>> componentIndexByUrn;
    private transient SetMultimap<Name, Name> modulesProvidingComponentsIndex;
    private final ResolutionStrategy resolutionStrategy;

    public ComponentTypeIndex(ResolutionStrategy resolutionStrategy) {
        this.componentIndexByUrn = ImmutableMap.of();
        this.modulesProvidingComponentsIndex = ImmutableSetMultimap.of();
        this.resolutionStrategy = resolutionStrategy;
    }

    @Deprecated
    public ComponentTypeIndex(ModuleEnvironment environment) {
        this(environment, (ResolutionStrategy)new ModuleDependencyResolutionStrategy(environment));
    }

    public ComponentTypeIndex(ModuleEnvironment environment, ResolutionStrategy resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        this.changeEnvironment(environment);
    }

    private static void indexUrn(Name moduleName, String typeName, Class<? extends Component> componentType, ImmutableMap.Builder<ResourceUrn, Class<? extends Component>> componentByUrnBuilder, ImmutableSetMultimap.Builder<Name, Name> modulesProvidingComponentsBuilder) {
        ResourceUrn urn = new ResourceUrn(moduleName, new Name(typeName));
        componentByUrnBuilder.put((Object)urn, componentType);
        modulesProvidingComponentsBuilder.put((Object)urn.getResourceName(), (Object)urn.getModuleName());
    }

    public void changeEnvironment(ModuleEnvironment environment) {
        ImmutableMap.Builder componentByUrnBuilder = ImmutableMap.builder();
        ImmutableSetMultimap.Builder modulesProvidingComponentsBuilder = ImmutableSetMultimap.builder();
        for (Class componentType : environment.getSubtypesOf(Component.class, x -> x != Component.class && !x.isInterface())) {
            Name module = environment.getModuleProviding(componentType);
            if (module == null) continue;
            ComponentTypeIndex.indexUrn(module, componentType.getSimpleName(), componentType, (ImmutableMap.Builder<ResourceUrn, Class<? extends Component>>)componentByUrnBuilder, (ImmutableSetMultimap.Builder<Name, Name>)modulesProvidingComponentsBuilder);
        }
        this.componentIndexByUrn = componentByUrnBuilder.build();
        this.modulesProvidingComponentsIndex = modulesProvidingComponentsBuilder.build();
    }

    public Optional<Class<? extends Component>> find(ResourceUrn urn) {
        return Optional.ofNullable(this.componentIndexByUrn.get(urn));
    }

    public Optional<Class<? extends Component>> find(Name name, Name moduleContext) {
        Set possibleModules = this.modulesProvidingComponentsIndex.get((Object)name);
        if (!moduleContext.isEmpty()) {
            possibleModules = this.resolutionStrategy.resolve(possibleModules, moduleContext);
        }
        if (possibleModules.size() == 1) {
            return this.find(new ResourceUrn((Name)possibleModules.iterator().next(), name));
        }
        return Optional.empty();
    }

    public Optional<Class<? extends Component>> find(Name name) {
        return this.find(name, ContextManager.getCurrentContext());
    }

    public Optional<Class<? extends Component>> find(String identity) {
        if (ResourceUrn.isValid((String)identity)) {
            return this.find(new ResourceUrn(identity));
        }
        return this.find(new Name(identity));
    }
}

