/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PropertyAccessor<T, U> {
    private final String name;
    private final Class<T> owningClass;
    private final Type propertyType;
    private final Function<T, U> getter;
    private final BiConsumer<T, U> setter;

    public PropertyAccessor(String name, Class<T> owningClass, Type propertyType, Function<T, U> getter, BiConsumer<T, U> setter) {
        this.name = name;
        this.owningClass = owningClass;
        this.propertyType = propertyType;
        this.getter = getter;
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getOwningClass() {
        return this.owningClass;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public Class<U> getPropertyClass() {
        if (this.propertyType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.propertyType).getRawType();
        }
        return (Class)this.propertyType;
    }

    public U get(T instance) {
        return this.getter.apply(instance);
    }

    public void set(T instance, U value) {
        this.setter.accept(instance, value);
    }
}

