/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.management;

import android.support.annotation.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.AbstractComponentTypeFactory;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeGenerationException;

public class ReflectionComponentTypeFactory
extends AbstractComponentTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionComponentTypeFactory.class);

    @Override
    protected <T extends Component<T>> Function<T, T> getCopyConstructor(Class<T> type) {
        try {
            Constructor constructor = type.getDeclaredConstructor(type);
            return from -> {
                try {
                    return (Component)constructor.newInstance(from);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new ComponentTypeGenerationException("Failed to instantiate " + type, e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    @NonNull
    protected <T extends Component<T>> Supplier<T> getEmptyConstructor(Class<T> type) {
        Supplier<Component> emptyConstructor;
        try {
            Constructor constructor = type.getDeclaredConstructor(new Class[0]);
            emptyConstructor = () -> {
                try {
                    return (Component)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new ComponentTypeGenerationException("Failed to instantiate " + type, e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new ComponentTypeGenerationException("Component type missing empty constructor: " + type, e);
        }
        return emptyConstructor;
    }

    @Override
    protected <T extends Component<T>> Function<T, Object> createGetterFunction(Method method, String propertyName, Type propertyType, Class<T> componentType) {
        return t -> {
            try {
                return method.invoke(t, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ComponentTypeGenerationException("Failed to invoke getter for '" + propertyName + "' of '" + componentType + "'", e);
            }
        };
    }

    @Override
    protected <T extends Component<T>> BiConsumer<T, Object> createSetterFunction(Method method, String propertyName, Type propertyType, Class<T> componentType) {
        return (t, o) -> {
            try {
                method.invoke(t, o);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ComponentTypeGenerationException("Failed to invoke setter for '" + propertyName + "' of '" + componentType + "'", e);
            }
        };
    }
}

