/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.store;

import java.lang.reflect.Array;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.ComponentIterator;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;

public class ArrayComponentStore<T extends Component<T>>
implements ComponentStore<T> {
    private final ComponentType<T> type;
    private T[] store;

    public ArrayComponentStore(ComponentType<T> componentType) {
        this(componentType, 1000);
    }

    public ArrayComponentStore(ComponentType<T> type, int initialCapacity) {
        this.type = type;
        this.store = (Component[])Array.newInstance(type.getComponentClass(), initialCapacity);
    }

    @Override
    public ComponentType<T> getType() {
        return this.type;
    }

    @Override
    public boolean has(int entityId) {
        return this.store[entityId] != null;
    }

    @Override
    public boolean get(int entityId, T into) {
        T value = this.store[entityId];
        if (value != null) {
            into.copy(this.store[entityId]);
            return true;
        }
        return false;
    }

    @Override
    public boolean set(int entityId, T component) {
        if (this.store[entityId] == null) {
            this.store[entityId] = this.type.createCopy(component);
            return true;
        }
        this.store[entityId].copy(component);
        return false;
    }

    @Override
    public T remove(int entityId) {
        T result = this.store[entityId];
        this.store[entityId] = null;
        return result;
    }

    @Override
    public int iterationCost() {
        return this.store.length;
    }

    @Override
    public ComponentIterator<T> iterate() {
        return new ArrayComponentIterator();
    }

    @Override
    public void extend(int capacity) {
        if (capacity >= this.store.length) {
            Component[] newStore = (Component[])Array.newInstance(this.type.getComponentClass(), capacity * 2);
            System.arraycopy(this.store, 0, newStore, 0, this.store.length);
            this.store = newStore;
        }
    }

    private class ArrayComponentIterator
    implements ComponentIterator<T> {
        private int index = -1;
        private int endIndex = ArrayComponentStore.access$100(ArrayComponentStore.this).length;

        private ArrayComponentIterator() {
        }

        @Override
        public boolean next() {
            ++this.index;
            while (this.index < this.endIndex && ArrayComponentStore.this.store[this.index] == null) {
                ++this.index;
            }
            return this.index < this.endIndex;
        }

        @Override
        public void getComponent(Component<T> component) {
            component.copy(ArrayComponentStore.this.store[this.index]);
        }

        @Override
        public int getEntityId() {
            return this.index;
        }

        public String toString() {
            return this.index + " of " + this.endIndex;
        }
    }
}

