/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.store;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.ComponentIterator;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;

@ThreadSafe
public class ConcurrentComponentStore<T extends Component<T>>
implements ComponentStore<T> {
    private final ComponentStore<T> store;
    private final ReadWriteLock locks = new ReentrantReadWriteLock();

    public ConcurrentComponentStore(ComponentStore<T> store) {
        this.store = store;
    }

    @Override
    public ComponentType<T> getType() {
        return this.store.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(int entityId) {
        Lock lock = this.locks.readLock();
        lock.lock();
        try {
            boolean bl = this.store.has(entityId);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(int entityId, T into) {
        Lock lock = this.locks.readLock();
        lock.lock();
        try {
            boolean bl = this.store.get(entityId, into);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(int entityId, T component) {
        Lock lock = this.locks.writeLock();
        lock.lock();
        try {
            boolean bl = this.store.set(entityId, component);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int entityId) {
        Lock lock = this.locks.writeLock();
        lock.lock();
        try {
            T t = this.store.remove(entityId);
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int iterationCost() {
        return this.store.iterationCost();
    }

    @Override
    public void extend(int capacity) {
        Lock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.store.extend(capacity);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ComponentIterator<T> iterate() {
        return new ConcurrentComponentIterator(this.store.iterate());
    }

    private class ConcurrentComponentIterator
    implements ComponentIterator<T> {
        private final ComponentIterator<T> inner;

        private ConcurrentComponentIterator(ComponentIterator<T> iterator) {
            this.inner = iterator;
        }

        @Override
        public boolean next() {
            Lock lock = ConcurrentComponentStore.this.locks.readLock();
            lock.lock();
            try {
                boolean bl = this.inner.next();
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int getEntityId() {
            return this.inner.getEntityId();
        }

        @Override
        public void getComponent(Component<T> component) {
            Lock lock = ConcurrentComponentStore.this.locks.readLock();
            lock.lock();
            try {
                this.inner.getComponent(component);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

