/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.component.store;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.ComponentIterator;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;

public class SparseComponentStore<T extends Component<T>>
implements ComponentStore<T> {
    private final ComponentType<T> type;
    private final TIntObjectMap<T> store = new TIntObjectHashMap();

    public SparseComponentStore(ComponentType<T> type) {
        this.type = type;
    }

    @Override
    public ComponentType<T> getType() {
        return this.type;
    }

    @Override
    public boolean has(int entityId) {
        return this.store.containsKey(entityId);
    }

    @Override
    public boolean get(int entityId, T into) {
        Component source = (Component)this.store.get(entityId);
        if (source == null) {
            return false;
        }
        into.copy((Component)source);
        return true;
    }

    @Override
    public boolean set(int entityId, T component) {
        Component stored = (Component)this.store.get(entityId);
        if (stored == null) {
            this.store.put(entityId, this.type.createCopy(component));
            return true;
        }
        stored.copy(component);
        return false;
    }

    @Override
    public int iterationCost() {
        return this.store.size();
    }

    @Override
    public ComponentIterator<T> iterate() {
        return new SparseComponentIterator();
    }

    @Override
    public T remove(int entityId) {
        return (T)((Component)this.store.remove(entityId));
    }

    @Override
    public void extend(int capacity) {
    }

    private class SparseComponentIterator
    implements ComponentIterator<T> {
        final TIntObjectIterator<T> iterator;

        private SparseComponentIterator() {
            this.iterator = SparseComponentStore.this.store.iterator();
        }

        @Override
        public boolean next() {
            if (this.iterator.hasNext()) {
                this.iterator.advance();
                return true;
            }
            return false;
        }

        @Override
        public int getEntityId() {
            return this.iterator.key();
        }

        @Override
        public void getComponent(Component<T> component) {
            component.copy((Component)this.iterator.value());
        }
    }
}

