/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.util.collection.TypeKeyedMap;

public interface EntityRef {
    public int getId();

    public boolean exists();

    public <T extends Component<T>> boolean getComponent(T var1);

    public <T extends Component<T>> Optional<T> getComponent(Class<T> var1);

    public <T extends Component<T>> boolean hasComponent(Class<T> var1);

    public Set<Class<? extends Component>> getComponentTypes();

    public TypeKeyedMap<Component> getAllComponents();

    public <T extends Component<T>> boolean setComponent(T var1);

    default public void setComponents(Component ... components) {
        this.setComponents(Arrays.asList(components));
    }

    default public void setComponents(Collection<Component> components) {
        if (this.exists()) {
            for (Component component : components) {
                this.setComponent(component);
            }
        }
    }

    public <T extends Component<T>> T removeComponent(Class<T> var1);

    default public Set<Component<?>> removeComponents(Class<? extends Component> ... componentTypes) {
        return this.removeComponents(Arrays.asList(componentTypes));
    }

    public Set<Component<?>> removeComponents(Collection<Class<? extends Component>> var1);

    public Set<Component<?>> delete();
}

