/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.entity.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.ComponentIterator;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.management.PropertyAccessor;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;
import org.terasology.gestalt.entitysystem.entity.EntityIterator;
import org.terasology.gestalt.entitysystem.entity.EntityManager;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.entity.NullEntityRef;
import org.terasology.gestalt.entitysystem.entity.manager.ManagedEntityRef;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipe;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipeRef;
import org.terasology.gestalt.entitysystem.prefab.GeneratedFromRecipeComponent;
import org.terasology.gestalt.entitysystem.prefab.Prefab;
import org.terasology.gestalt.entitysystem.prefab.PrefabRef;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.util.collection.TypeKeyedMap;
import org.terasology.gestalt.util.collection.UniqueQueue;

@ThreadSafe
public class CoreEntityManager
implements EntityManager {
    private static final Logger logger = LoggerFactory.getLogger(CoreEntityManager.class);
    private static final int DEFAULT_CAPACITY = 1024;
    private static final double EXTENSION_RATE = 1.5;
    private final ReadWriteLock locks = new ReentrantReadWriteLock();
    private final Map<Class<? extends Component>, ComponentStore<?>> componentStores;
    private final UniqueQueue<Integer> freedIdQueue = new UniqueQueue();
    private EntityRef[] entities;
    private int nextId = 0;

    public CoreEntityManager(ComponentStore<?> ... componentStores) {
        this(Arrays.asList(componentStores), 1024);
    }

    public CoreEntityManager(Collection<ComponentStore<?>> componentStores) {
        this(componentStores, 1024);
    }

    public CoreEntityManager(Collection<ComponentStore<?>> componentStores, int capacity) {
        this.componentStores = new ConcurrentHashMap();
        for (ComponentStore<?> store : componentStores) {
            this.componentStores.put(store.getType().getComponentClass(), store);
            store.extend(capacity);
        }
        this.entities = new EntityRef[capacity];
        Arrays.fill(this.entities, NullEntityRef.get());
    }

    public void addComponentStore(ComponentStore<?> store) {
        Lock lock = this.locks.readLock();
        lock.lock();
        try {
            store.extend(this.entities.length);
            if (this.componentStores.containsKey(store.getType().getComponentClass())) {
                throw new IllegalStateException("Component store for type " + store.getType() + " already present");
            }
            this.componentStores.put(store.getType().getComponentClass(), store);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityRef getEntity(int id) {
        Lock lock = this.locks.readLock();
        lock.lock();
        try {
            EntityRef entityRef = this.entities[id];
            return entityRef;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityRef createEntity() {
        Lock lock = this.locks.readLock();
        lock.lock();
        try {
            int id;
            if (this.freedIdQueue.isEmpty()) {
                if ((id = this.nextId++) >= this.entities.length) {
                    this.extendStorage();
                }
            } else {
                id = (Integer)this.freedIdQueue.remove();
            }
            ManagedEntityRef result = new ManagedEntityRef(this, id);
            this.entities[id] = result;
            ManagedEntityRef managedEntityRef = result;
            return managedEntityRef;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public EntityRef createEntity(Collection<Component> components) {
        EntityRef entity = this.createEntity();
        entity.setComponents(components);
        return entity;
    }

    void freeEntityId(int id) {
        Lock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.freedIdQueue.add((Object)id);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.nextId - this.freedIdQueue.size();
    }

    @Override
    public EntityIterator iterate(Component ... components) {
        ArrayList componentsOrdered = Lists.newArrayList((Object[])components);
        componentsOrdered.sort(Comparator.comparing(x -> this.componentStores.get(x.getClass()).iterationCost()));
        List stores = componentsOrdered.stream().map(x -> this.componentStores.get(x.getClass())).collect(Collectors.toList());
        ComponentIterator drivingIterator = ((ComponentStore)stores.get(0)).iterate();
        return new ComponentsIterator(drivingIterator, componentsOrdered, stores);
    }

    @Override
    public <T extends Component<T>> ComponentStore<T> getComponentStore(Class<T> componentType) {
        return this.componentStores.get(componentType);
    }

    @Override
    public EntityRef createEntity(Prefab prefab) {
        Map<Name, EntityRef> entities = this.createEntities(prefab);
        return entities.get(prefab.getRootEntityUrn().getFragmentName());
    }

    @Override
    public Map<Name, EntityRef> createEntities(Prefab prefab) {
        Map<Name, EntityRef> result = this.createPrefabEntities(prefab);
        this.populatePrefabEntities(prefab, result);
        return result;
    }

    private void populatePrefabEntities(Prefab prefab, Map<Name, EntityRef> result) {
        for (EntityRecipe entityRecipe : prefab.getEntityRecipes().values()) {
            EntityRef entity = result.get(entityRecipe.getIdentifier().getFragmentName());
            GeneratedFromRecipeComponent prefabComponent = new GeneratedFromRecipeComponent();
            prefabComponent.setEntityRecipe(entityRecipe.getIdentifier());
            entity.setComponent(prefabComponent);
            for (TypeKeyedMap.Entry entry : entityRecipe.getComponents().entrySet()) {
                ComponentType<?> componentType = this.componentStores.get(entry.getKey()).getType();
                Component component = componentType.createCopy((Component)entry.getValue());
                this.processReferences(componentType, component, entityRecipe.getIdentifier(), result);
                entity.setComponent(component);
            }
        }
    }

    private void processReferences(ComponentType<?> componentType, Component component, ResourceUrn entityRecipeUrn, Map<Name, EntityRef> entityMap) {
        for (PropertyAccessor<?, EntityRef> property : componentType.getPropertyInfo().getPropertiesOfType(EntityRef.class)) {
            EntityRef newRef;
            EntityRef existing = property.get(component);
            if (existing instanceof EntityRecipeRef) {
                newRef = entityMap.get(((EntityRecipeRef)existing).getRecipe().getIdentifier().getFragmentName());
                if (newRef == null) {
                    logger.error("{} references external or unknown entity prefab {}", (Object)entityRecipeUrn, (Object)existing);
                    newRef = NullEntityRef.get();
                }
            } else if (existing instanceof PrefabRef) {
                newRef = this.createEntity(((PrefabRef)existing).getPrefab());
            } else {
                logger.error("{} contains unsupported entity ref {}", (Object)entityRecipeUrn, (Object)existing);
                newRef = NullEntityRef.get();
            }
            property.set(component, newRef);
        }
    }

    private Map<Name, EntityRef> createPrefabEntities(Prefab prefab) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (EntityRecipe entityRecipe : prefab.getEntityRecipes().values()) {
            result.put(entityRecipe.getIdentifier().getFragmentName(), this.createEntity());
        }
        return result;
    }

    @Override
    public Iterable<EntityRef> allEntities() {
        return Collections.unmodifiableList(Arrays.asList(this.entities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extendStorage() {
        Lock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (this.entities.length <= this.nextId) {
                int newSize = Math.min((int)((double)this.entities.length * 1.5), this.entities.length + 1);
                Object[] newEntities = new EntityRef[newSize];
                System.arraycopy(this.entities, 0, newEntities, 0, this.entities.length);
                Arrays.fill(newEntities, this.entities.length, newEntities.length, NullEntityRef.get());
                this.entities = newEntities;
                for (ComponentStore<?> store : this.componentStores.values()) {
                    store.extend(this.entities.length);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterable<ComponentStore<?>> allComponentStores() {
        return this.componentStores.values();
    }

    private class ComponentsIterator
    implements EntityIterator {
        private ComponentIterator drivingIterator;
        private List<Component> components;
        private List<ComponentStore> componentStores;

        private ComponentsIterator(ComponentIterator drivingIterator, List<Component> components, List<ComponentStore> componentStores) {
            this.drivingIterator = drivingIterator;
            this.components = components;
            this.componentStores = componentStores;
        }

        @Override
        public boolean next() {
            while (this.drivingIterator.next()) {
                int entityId = this.drivingIterator.getEntityId();
                boolean found = true;
                for (int i = 1; i < this.componentStores.size(); ++i) {
                    if (this.componentStores.get(i).get(entityId, this.components.get(i))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                this.drivingIterator.getComponent(this.components.get(0));
                return true;
            }
            return false;
        }

        @Override
        public EntityRef getEntity() {
            return CoreEntityManager.this.getEntity(this.drivingIterator.getEntityId());
        }
    }
}

