/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.entity.manager;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.entity.manager.CoreEntityManager;
import org.terasology.gestalt.util.collection.TypeKeyedMap;

@ThreadSafe
class ManagedEntityRef
implements EntityRef {
    private volatile CoreEntityManager entityManager;
    private final int id;

    ManagedEntityRef(CoreEntityManager entityManager, int entityId) {
        this.entityManager = entityManager;
        this.id = entityId;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean exists() {
        return this.entityManager != null;
    }

    @Override
    public <T extends Component<T>> boolean hasComponent(Class<T> type) {
        if (this.entityManager != null) {
            return this.entityManager.getComponentStore(type).has(this.id);
        }
        return false;
    }

    @Override
    public <T extends Component<T>> boolean getComponent(T component) {
        if (this.entityManager != null) {
            return this.entityManager.getComponentStore(component.getClass()).get(this.id, component);
        }
        return false;
    }

    @Override
    public <T extends Component<T>> Optional<T> getComponent(Class<T> componentType) {
        T result;
        ComponentStore<T> componentStore = this.entityManager.getComponentStore(componentType);
        if (componentStore.get(this.id, result = componentStore.getType().create())) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    @Override
    public <T extends Component<T>> boolean setComponent(T component) {
        if (this.entityManager != null) {
            return this.entityManager.getComponentStore(component.getClass()).set(this.id, component);
        }
        return false;
    }

    @Override
    public <T extends Component<T>> T removeComponent(Class<T> componentType) {
        if (this.entityManager != null) {
            return this.entityManager.getComponentStore(componentType).remove(this.id);
        }
        return null;
    }

    @Override
    public Set<Component<?>> removeComponents(Collection<Class<? extends Component>> componentTypes) {
        return null;
    }

    @Override
    public Set<Class<? extends Component>> getComponentTypes() {
        if (this.entityManager != null) {
            LinkedHashSet types = Sets.newLinkedHashSet();
            for (ComponentStore<?> store : this.entityManager.allComponentStores()) {
                if (!store.has(this.id)) continue;
                types.add(store.getType().getComponentClass());
            }
            return types;
        }
        return Collections.emptySet();
    }

    @Override
    public TypeKeyedMap<Component> getAllComponents() {
        if (this.entityManager != null) {
            TypeKeyedMap components = new TypeKeyedMap();
            for (ComponentStore<?> store : this.entityManager.allComponentStores()) {
                this.addComponentFromStore(store, (TypeKeyedMap<Component>)components);
            }
            return components;
        }
        return TypeKeyedMap.empty();
    }

    private <T extends Component<T>> void addComponentFromStore(ComponentStore<T> store, TypeKeyedMap<Component> components) {
        T component = store.getType().create();
        store.get(this.id, component);
        components.put(component);
    }

    @Override
    public Set<Component<?>> delete() {
        LinkedHashSet removedComponents = Sets.newLinkedHashSet();
        if (this.entityManager != null) {
            for (ComponentStore<?> store : this.entityManager.allComponentStores()) {
                Object removed = store.remove(this.id);
                if (removed == null) continue;
                removedComponents.add(removed);
            }
            this.entityManager.freeEntityId(this.id);
            this.entityManager = null;
        }
        return removedComponents;
    }

    public String toString() {
        if (this.entityManager != null) {
            return "EntityRef(" + this.id + ")";
        }
        return "EntityRef(deleted)";
    }
}

