/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventHandler;

public interface EventSystem {
    default public void send(Event event, EntityRef entity) {
        this.send(event, entity, Collections.emptySet());
    }

    public void send(Event var1, EntityRef var2, Set<Class<? extends Component>> var3);

    public void processEvents();

    public void clearPendingEvents();

    default public <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Class<? extends Component> ... requiredComponents) {
        this.registerHandler(eventClass, eventHandler, eventHandler.getClass(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(requiredComponents));
    }

    default public <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Iterable<Class<? extends Component>> requiredComponents) {
        this.registerHandler(eventClass, eventHandler, eventHandler.getClass(), Collections.emptyList(), Collections.emptyList(), requiredComponents);
    }

    default public <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Collection<Class<?>> before, Collection<Class<?>> after, Class<? extends Component> ... requiredComponents) {
        this.registerHandler(eventClass, eventHandler, eventHandler.getClass(), before, after, Arrays.asList(requiredComponents));
    }

    default public <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Collection<Class<?>> before, Collection<Class<?>> after, Iterable<Class<? extends Component>> requiredComponents) {
        this.registerHandler(eventClass, eventHandler, eventHandler.getClass(), before, after, requiredComponents);
    }

    default public <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Class<?> provider, Collection<Class<?>> before, Collection<Class<?>> after, Class<? extends Component> ... requiredComponents) {
        this.registerHandler(eventClass, eventHandler, provider, before, after, Arrays.asList(requiredComponents));
    }

    public <T extends Event> void registerHandler(Class<T> var1, EventHandler<? super T> var2, Class<?> var3, Collection<Class<?>> var4, Collection<Class<?>> var5, Iterable<Class<? extends Component>> var6);

    public boolean removeHandlers(Class<?> var1);

    public boolean removeHandler(EventHandler<?> var1);
}

