/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventHandler;
import org.terasology.gestalt.entitysystem.event.EventResult;
import org.terasology.gestalt.util.collection.KahnSorter;

public class EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EventProcessor.class);
    private final List<EventProcessor> children = new ArrayList<EventProcessor>();
    private final List<EventHandlerRegistration> eventHandlers = new CopyOnWriteArrayList<EventHandlerRegistration>();
    private final Multimap<Class<?>, EventHandlerRegistration> eventHandlersByProvider = ArrayListMultimap.create();

    public EventProcessor() {
        this(null);
    }

    public EventProcessor(EventProcessor parent) {
        if (parent != null) {
            parent.children.add(this);
            this.eventHandlers.addAll(parent.eventHandlers);
            this.eventHandlersByProvider.putAll(parent.eventHandlersByProvider);
        }
    }

    public EventResult process(Event event, EntityRef entity) {
        return this.process(event, entity, Collections.emptySet());
    }

    public EventResult process(Event event, EntityRef entity, Set<Class<? extends Component>> triggeringComponents) {
        EventResult result = EventResult.CONTINUE;
        Set<Class<? extends Component>> componentTypes = entity.getComponentTypes();
        for (EventHandlerRegistration handler : this.eventHandlers) {
            if (!this.validToInvoke(handler, componentTypes, triggeringComponents)) continue;
            try {
                result = handler.invoke(event, entity);
                switch (result) {
                    case COMPLETE: 
                    case CANCEL: {
                        return result;
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error("Exception thrown when processing event {}", event.getClass(), (Object)e);
            }
        }
        if (result == EventResult.CONTINUE) {
            return EventResult.COMPLETE;
        }
        return result;
    }

    private boolean validToInvoke(EventHandlerRegistration handler, Set<Class<? extends Component>> targetComponents, Set<Class<? extends Component>> triggeringComponents) {
        for (Class component : handler.components) {
            if (targetComponents.contains(component) || triggeringComponents.contains(component)) continue;
            return false;
        }
        if (!triggeringComponents.isEmpty()) {
            for (Class component : handler.components) {
                if (!triggeringComponents.contains(component)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public synchronized void registerHandler(EventHandler<?> eventHandler, Class<?> provider, Collection<Class<?>> before, Collection<Class<?>> after, Iterable<Class<? extends Component>> requiredComponents) {
        this.children.forEach(child -> child.registerHandler(eventHandler, provider, before, after, requiredComponents));
        EventHandlerRegistration eventHandlerRegistration = new EventHandlerRegistration(eventHandler, before, after, requiredComponents);
        this.eventHandlersByProvider.put(provider, (Object)eventHandlerRegistration);
        this.sortHandlers();
    }

    private void sortHandlers() {
        KahnSorter sorter = new KahnSorter();
        sorter.addNodes(this.eventHandlersByProvider.values());
        for (EventHandlerRegistration eventHandler : this.eventHandlersByProvider.values()) {
            for (Class beforeProvider : eventHandler.before) {
                this.eventHandlersByProvider.get((Object)beforeProvider).forEach(x -> sorter.addEdge((Object)eventHandler, x));
            }
            for (Class afterProvider : eventHandler.after) {
                this.eventHandlersByProvider.get((Object)afterProvider).forEach(x -> sorter.addEdge(x, (Object)eventHandler));
            }
        }
        this.eventHandlers.clear();
        this.eventHandlers.addAll(sorter.sort());
    }

    public synchronized boolean removeProvider(Class<?> provider) {
        return this.eventHandlers.removeAll(this.eventHandlersByProvider.removeAll(provider));
    }

    public synchronized boolean removeHandler(EventHandler<?> handler) {
        if (this.eventHandlersByProvider.values().removeIf(x -> ((EventHandlerRegistration)x).receiver.equals(handler))) {
            return this.eventHandlers.removeIf(x -> ((EventHandlerRegistration)x).receiver.equals(handler));
        }
        return false;
    }

    private static class EventHandlerRegistration {
        private final EventHandler receiver;
        private final ImmutableList<Class<? extends Component>> components;
        private final List<Class<?>> before;
        private final List<Class<?>> after;

        EventHandlerRegistration(EventHandler<?> receiver, Iterable<Class<?>> before, Iterable<Class<?>> after, Iterable<Class<? extends Component>> requiredComponents) {
            this.receiver = receiver;
            this.components = ImmutableList.copyOf(requiredComponents);
            this.before = ImmutableList.copyOf(before);
            this.after = ImmutableList.copyOf(after);
        }

        EventResult invoke(Event event, EntityRef entity) {
            return this.receiver.onEvent(event, entity);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof EventHandlerRegistration) {
                EventHandlerRegistration other = (EventHandlerRegistration)obj;
                return Objects.equals(this.receiver, other.receiver);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.receiver);
        }
    }
}

