/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.event.After;
import org.terasology.gestalt.entitysystem.event.Before;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventHandler;
import org.terasology.gestalt.entitysystem.event.EventHandlerFactory;
import org.terasology.gestalt.entitysystem.event.EventSystem;
import org.terasology.gestalt.entitysystem.event.ReceiveEvent;
import org.terasology.gestalt.entitysystem.event.exception.InvalidEventReceiverObjectException;
import org.terasology.gestalt.entitysystem.event.impl.ReflectionEventHandler;

public final class EventReceiverMethodSupport {
    public static final int FIXED_PARAM_COUNT = 2;
    private static final Logger logger = LoggerFactory.getLogger(EventReceiverMethodSupport.class);
    private EventHandlerFactory eventHandlerFactory;

    public EventReceiverMethodSupport() {
        this(ReflectionEventHandler::new);
    }

    public EventReceiverMethodSupport(EventHandlerFactory eventHandlerFactory) {
        this.eventHandlerFactory = eventHandlerFactory;
    }

    public void register(Object eventReceiverObject, EventSystem eventSystem) {
        Class<?> handlerClass = eventReceiverObject.getClass();
        if (!Modifier.isPublic(handlerClass.getModifiers())) {
            throw new InvalidEventReceiverObjectException("Cannot register handler " + handlerClass.getName() + ", must be public");
        }
        ImmutableSet globalBefore = handlerClass.isAnnotationPresent(Before.class) ? ImmutableSet.copyOf((Object[])handlerClass.getAnnotation(Before.class).value()) : Collections.emptySet();
        ImmutableSet globalAfter = handlerClass.isAnnotationPresent(After.class) ? ImmutableSet.copyOf((Object[])handlerClass.getAnnotation(After.class).value()) : Collections.emptySet();
        logger.debug("Registering event handler " + handlerClass.getName());
        for (Method method : handlerClass.getMethods()) {
            ReceiveEvent receiveEventAnnotation = method.getAnnotation(ReceiveEvent.class);
            if (receiveEventAnnotation == null) continue;
            logger.debug("Found method: " + method.toString());
            method.setAccessible(true);
            Class<?>[] types = method.getParameterTypes();
            if (!this.methodParametersValid(types)) {
                logger.error("Invalid event handler method: {}::{}", (Object)handlerClass.getSimpleName(), (Object)method.getName());
                continue;
            }
            LinkedHashSet requiredComponents = Sets.newLinkedHashSet(Arrays.asList(receiveEventAnnotation.components()));
            List<Class<? extends Component>> componentParams = this.gatherComponentParameters(types);
            requiredComponents.addAll(componentParams);
            this.registerEventHandler(this.eventHandlerFactory.create(eventReceiverObject, method, componentParams), eventSystem, handlerClass, (Set<Class<?>>)globalBefore, (Set<Class<?>>)globalAfter, method, (Class)types[0], requiredComponents);
        }
    }

    private <T extends Event> void registerEventHandler(EventHandler<T> eventHandler, EventSystem eventSystem, Class<?> handlerClass, Set<Class<?>> globalBefore, Set<Class<?>> globalAfter, Method method, Class<? extends T> type, Set<Class<? extends Component>> requiredComponents) {
        ImmutableSet beforeUnion = globalBefore;
        if (method.isAnnotationPresent(Before.class)) {
            beforeUnion = ImmutableSet.builder().addAll(globalBefore).addAll(Arrays.asList(method.getAnnotation(Before.class).value())).build();
        }
        ImmutableSet afterUnion = globalAfter;
        if (method.isAnnotationPresent(After.class)) {
            afterUnion = ImmutableSet.builder().addAll(globalAfter).addAll(Arrays.asList(method.getAnnotation(After.class).value())).build();
        }
        eventSystem.registerHandler(type, eventHandler, handlerClass, (Collection<Class<?>>)beforeUnion, (Collection<Class<?>>)afterUnion, (Iterable<Class<? extends Component>>)requiredComponents);
    }

    private List<Class<? extends Component>> gatherComponentParameters(Class<?>[] types) {
        ArrayList componentParams = Lists.newArrayList();
        for (int i = 2; i < types.length; ++i) {
            componentParams.add(types[i]);
        }
        return componentParams;
    }

    private boolean methodParametersValid(Class<?>[] types) {
        if (!Event.class.isAssignableFrom(types[0]) && Long.TYPE.isAssignableFrom(types[1])) {
            return false;
        }
        for (int i = 2; i < types.length; ++i) {
            if (Component.class.isAssignableFrom(types[i])) continue;
            return false;
        }
        return true;
    }
}

