/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventHandler;
import org.terasology.gestalt.entitysystem.event.EventSystem;
import org.terasology.gestalt.entitysystem.event.Synchronous;
import org.terasology.gestalt.entitysystem.event.impl.EventProcessor;

@ThreadSafe
public class EventSystemImpl
implements EventSystem {
    private static final Logger logger = LoggerFactory.getLogger(EventSystemImpl.class);
    private final BlockingQueue<PendingEventInfo> pendingEvents = new LinkedBlockingQueue<PendingEventInfo>();
    private final Map<Class<? extends Event>, EventProcessor> eventProcessorLookup = new LinkedHashMap<Class<? extends Event>, EventProcessor>();

    @Override
    public void send(Event event, EntityRef entity, Set<Class<? extends Component>> triggeringComponents) {
        if (event.getClass().isAnnotationPresent(Synchronous.class)) {
            this.processEvent(event, entity, triggeringComponents);
        } else {
            this.pendingEvents.add(new PendingEventInfo(event, entity, triggeringComponents));
        }
    }

    @Override
    public synchronized void processEvents() {
        ArrayList events = Lists.newArrayListWithExpectedSize((int)this.pendingEvents.size());
        while (!this.pendingEvents.isEmpty()) {
            this.pendingEvents.drainTo(events);
            for (PendingEventInfo eventInfo : events) {
                this.processEvent(eventInfo.getEvent(), eventInfo.getEntity(), eventInfo.triggeringComponents);
            }
        }
    }

    @Override
    public void clearPendingEvents() {
        this.pendingEvents.clear();
    }

    private synchronized void processEvent(Event event, EntityRef entity, Set<Class<? extends Component>> triggeringComponents) {
        if (entity.exists()) {
            EventProcessor eventProcessor = this.getEventProcessor(event.getClass());
            eventProcessor.process(event, entity, triggeringComponents);
        }
    }

    @Override
    public synchronized <T extends Event> void registerHandler(Class<T> eventClass, EventHandler<? super T> eventHandler, Class<?> provider, Collection<Class<?>> before, Collection<Class<?>> after, Iterable<Class<? extends Component>> requiredComponents) {
        EventProcessor eventProcessor = this.getEventProcessor(eventClass);
        eventProcessor.registerHandler(eventHandler, provider, before, after, requiredComponents);
    }

    @Override
    public synchronized boolean removeHandlers(Class<?> provider) {
        boolean result = false;
        for (EventProcessor processor : this.eventProcessorLookup.values()) {
            result |= processor.removeProvider(provider);
        }
        return result;
    }

    @Override
    public synchronized boolean removeHandler(EventHandler<?> handler) {
        boolean result = false;
        for (EventProcessor processor : this.eventProcessorLookup.values()) {
            result |= processor.removeHandler(handler);
        }
        return result;
    }

    private synchronized EventProcessor getEventProcessor(Class<? extends Event> eventClass) {
        EventProcessor eventProcessor = this.eventProcessorLookup.get(eventClass);
        if (eventProcessor == null) {
            eventProcessor = this.createEventProcessor(eventClass);
        }
        return eventProcessor;
    }

    private EventProcessor createEventProcessor(Class<? extends Event> eventClass) {
        EventProcessor processor;
        if (Event.class.isAssignableFrom(eventClass.getSuperclass())) {
            EventProcessor parentProcessor = this.getEventProcessor(eventClass.getSuperclass());
            processor = new EventProcessor(parentProcessor);
        } else {
            processor = new EventProcessor();
        }
        this.eventProcessorLookup.put(eventClass, processor);
        return processor;
    }

    private static class PendingEventInfo {
        private final Event event;
        private final EntityRef entity;
        private final Set<Class<? extends Component>> triggeringComponents;

        private PendingEventInfo(Event event, EntityRef entity, Set<Class<? extends Component>> triggeringComponents) {
            this.event = event;
            this.entity = entity;
            this.triggeringComponents = ImmutableSet.copyOf(triggeringComponents);
        }

        public EntityRef getEntity() {
            return this.entity;
        }

        public Event getEvent() {
            return this.event;
        }

        public Set<Class<? extends Component>> getTriggeringComponents() {
            return this.triggeringComponents;
        }
    }
}

