/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventHandler;
import org.terasology.gestalt.entitysystem.event.EventResult;
import org.terasology.gestalt.entitysystem.event.exception.EventSystemException;

public class ReflectionEventHandler
implements EventHandler {
    private Object handler;
    private Method method;
    private ImmutableList<Class<? extends Component>> componentParams;

    public ReflectionEventHandler(Object handler, Method method, Collection<Class<? extends Component>> componentParams) {
        this.handler = handler;
        this.method = method;
        this.componentParams = ImmutableList.copyOf(componentParams);
    }

    public EventResult onEvent(Event event, EntityRef entity) {
        try {
            Object[] params = new Object[2 + this.componentParams.size()];
            params[0] = event;
            params[1] = entity;
            for (int i = 0; i < this.componentParams.size(); ++i) {
                params[i + 2] = this.getComponent(entity, (Class)this.componentParams.get(i));
            }
            return (EventResult)((Object)this.method.invoke(this.handler, params));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new EventSystemException("Error processing event", ex);
        }
    }

    private <T extends Component<T>> T getComponent(EntityRef entity, Class<T> componentType) {
        return (T)((Component)entity.getComponent(componentType).orElseThrow(() -> new EventSystemException("Component unexpectedly missing")));
    }
}

