/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.lifecycle;

import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.ComponentIterator;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.store.ComponentStore;
import org.terasology.gestalt.entitysystem.entity.EntityManager;
import org.terasology.gestalt.entitysystem.event.lifecycle.LifecycleEventManager;

public class LifecycleAwareComponentStore<T extends Component<T>>
implements ComponentStore<T> {
    private final LifecycleEventManager lifecycleEventManager;
    private final ComponentStore<T> inner;
    private final EntityManager entityManager;

    public LifecycleAwareComponentStore(LifecycleEventManager lifecycleEventManager, EntityManager entityManager, ComponentStore<T> inner) {
        this.inner = inner;
        this.lifecycleEventManager = lifecycleEventManager;
        this.entityManager = entityManager;
    }

    @Override
    public boolean set(int entityId, T component) {
        if (this.inner.set(entityId, component)) {
            this.lifecycleEventManager.componentAdded(this.entityManager.getEntity(entityId), component.getClass());
            return true;
        }
        this.lifecycleEventManager.componentChanged(this.entityManager.getEntity(entityId), component.getClass());
        return false;
    }

    @Override
    public T remove(int entityId) {
        T result = this.inner.remove(entityId);
        if (result != null) {
            this.lifecycleEventManager.componentRemoved(this.entityManager.getEntity(entityId), result);
        }
        return result;
    }

    @Override
    public ComponentType<T> getType() {
        return this.inner.getType();
    }

    @Override
    public boolean has(int entityId) {
        return this.inner.has(entityId);
    }

    @Override
    public boolean get(int entityId, T into) {
        return this.inner.get(entityId, into);
    }

    @Override
    public int iterationCost() {
        return this.inner.iterationCost();
    }

    @Override
    public void extend(int capacity) {
        this.inner.extend(capacity);
    }

    @Override
    public ComponentIterator<T> iterate() {
        return this.inner.iterate();
    }
}

