/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.event.lifecycle;

import java.util.LinkedHashMap;
import java.util.Map;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.event.Event;
import org.terasology.gestalt.entitysystem.event.EventSystem;
import org.terasology.gestalt.entitysystem.event.lifecycle.LifecycleEvent;
import org.terasology.gestalt.entitysystem.event.lifecycle.OnAdded;
import org.terasology.gestalt.entitysystem.event.lifecycle.OnChanged;
import org.terasology.gestalt.entitysystem.event.lifecycle.OnRemoved;

public class LifecycleEventManager {
    private Map<EntityRef, OnAdded> onAddedEvents = new LinkedHashMap<EntityRef, OnAdded>();
    private Map<EntityRef, OnChanged> onChangedEvents = new LinkedHashMap<EntityRef, OnChanged>();
    private Map<EntityRef, OnRemoved> onRemovedEvents = new LinkedHashMap<EntityRef, OnRemoved>();

    public <T extends Component<T>> void componentAdded(EntityRef entity, Class<T> componentType) {
        OnAdded onAdded = this.onAddedEvents.get(entity);
        if (onAdded == null) {
            onAdded = new OnAdded(componentType);
            this.onAddedEvents.put(entity, onAdded);
        } else {
            onAdded.getComponentTypes().add(componentType);
        }
        OnRemoved onRemoved = this.onRemovedEvents.get(entity);
        if (onRemoved != null && onRemoved.getComponentTypes().remove(componentType)) {
            this.componentChanged(entity, componentType);
        }
    }

    public <T extends Component<T>> void componentChanged(EntityRef entity, Class<T> componentType) {
        OnChanged onChanged = this.onChangedEvents.get(entity);
        if (onChanged == null) {
            onChanged = new OnChanged(componentType);
            this.onChangedEvents.put(entity, onChanged);
        } else {
            onChanged.getComponentTypes().add(componentType);
        }
    }

    public <T extends Component<T>> void componentRemoved(EntityRef entity, T component) {
        OnChanged onChanged;
        OnRemoved onRemoved = this.onRemovedEvents.get(entity);
        if (onRemoved == null) {
            onRemoved = new OnRemoved(component);
            this.onRemovedEvents.put(entity, onRemoved);
        } else {
            onRemoved.getComponents().put(component);
        }
        OnAdded onAdded = this.onAddedEvents.get(entity);
        if (onAdded != null) {
            onAdded.getComponentTypes().remove(component.getClass());
        }
        if ((onChanged = this.onChangedEvents.get(entity)) != null) {
            onChanged.getComponentTypes().remove(component.getClass());
        }
    }

    public void sendPendingEvents(EventSystem eventSystem) {
        this.sendEvents(eventSystem, this.onAddedEvents);
        this.sendEvents(eventSystem, this.onChangedEvents);
        this.sendEvents(eventSystem, this.onRemovedEvents);
    }

    private void sendEvents(EventSystem eventSystem, Map<EntityRef, ? extends LifecycleEvent> events) {
        events.forEach((ref, event) -> {
            if (!event.getComponentTypes().isEmpty()) {
                eventSystem.send((Event)event, (EntityRef)ref, event.getComponentTypes());
            }
        });
        events.clear();
    }
}

