/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.prefab;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipeRef;
import org.terasology.gestalt.util.collection.TypeKeyedMap;

public class EntityRecipe {
    private final ResourceUrn identifier;
    private final EntityRecipeRef recipeRef;
    private TypeKeyedMap<Component> componentMap = new TypeKeyedMap((Map)ImmutableMap.of());

    public EntityRecipe(ResourceUrn identifier) {
        Preconditions.checkArgument((!identifier.getFragmentName().isEmpty() ? 1 : 0) != 0, (Object)"EntityRecipe identifiers must have a fragment name");
        this.identifier = identifier;
        this.recipeRef = new EntityRecipeRef(this);
    }

    public EntityRecipe(ResourceUrn prefabIdentifier, String identifier) {
        this.identifier = new ResourceUrn(prefabIdentifier, identifier);
        this.recipeRef = new EntityRecipeRef(this);
    }

    public EntityRecipeRef getReference() {
        return this.recipeRef;
    }

    public ResourceUrn getIdentifier() {
        return this.identifier;
    }

    public <T extends Component<T>> Optional<T> getComponent(Class<T> componentType) {
        return Optional.ofNullable(componentType.cast(this.componentMap.get(componentType)));
    }

    public TypeKeyedMap<Component> getComponents() {
        return this.componentMap;
    }

    public synchronized <T extends Component<T>> void add(T component) {
        this.componentMap = new TypeKeyedMap((Map)ImmutableMap.builder().putAll(this.componentMap.getInner()).put(component.getClass(), component).build());
    }

    public <T extends Component<T>> void remove(final Class<T> componentType) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        this.componentMap.forEach((TypeKeyedMap.EntryConsumer)new TypeKeyedMap.EntryConsumer<Component>(){

            public <U extends Component> void accept(Class<U> type, U value) {
                if (type != componentType) {
                    builder.put(type, value);
                }
            }
        });
        this.componentMap = new TypeKeyedMap((Map)builder.build());
    }

    public String toString() {
        return "EntityRecipe(" + this.identifier + ")";
    }
}

