/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.prefab;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.terasology.gestalt.assets.Asset;
import org.terasology.gestalt.assets.AssetType;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.exceptions.InvalidAssetDataException;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipe;
import org.terasology.gestalt.entitysystem.prefab.PrefabData;

public class Prefab
extends Asset<PrefabData> {
    private ResourceUrn rootEntityId;
    private Map<ResourceUrn, EntityRecipe> recipes;

    public Prefab(ResourceUrn urn, AssetType<?, PrefabData> assetType, PrefabData data) {
        super(urn, assetType);
        this.reload(data);
    }

    protected void doReload(PrefabData data) {
        for (ResourceUrn recipeUrn : data.getRecipes().keySet()) {
            if (this.getUrn().equals((Object)recipeUrn.getRootUrn())) continue;
            throw new InvalidAssetDataException("PrefabData contains recipe that does not belong to this prefab - " + recipeUrn.toString());
        }
        this.rootEntityId = data.getRootEntityId();
        this.recipes = ImmutableMap.copyOf(data.getRecipes());
    }

    public ResourceUrn getRootEntityUrn() {
        return this.rootEntityId;
    }

    public EntityRecipe getRootEntity() {
        return this.recipes.get(this.rootEntityId);
    }

    public Map<ResourceUrn, EntityRecipe> getEntityRecipes() {
        return this.recipes;
    }
}

