/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.prefab;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.terasology.gestalt.assets.AssetData;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipe;

public class PrefabData
implements AssetData {
    private ResourceUrn rootEntityId;
    private Map<ResourceUrn, EntityRecipe> recipes = Maps.newLinkedHashMap();

    public ResourceUrn getRootEntityId() {
        return this.rootEntityId;
    }

    public void setRootEntityId(ResourceUrn rootEntityId) {
        Preconditions.checkArgument((boolean)this.recipes.containsKey(rootEntityId));
        this.rootEntityId = rootEntityId;
    }

    public Map<ResourceUrn, EntityRecipe> getRecipes() {
        return Collections.unmodifiableMap(this.recipes);
    }

    public void addEntityRecipe(EntityRecipe recipe) {
        this.recipes.put(recipe.getIdentifier(), recipe);
        if (this.rootEntityId == null) {
            this.rootEntityId = recipe.getIdentifier();
        }
    }

    public void removeEntityPrefab(EntityRecipe recipe) {
        this.recipes.remove(recipe.getIdentifier());
    }
}

