/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gestalt.entitysystem.prefab;

import com.google.common.collect.Queues;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.assets.format.AbstractAssetFileFormat;
import org.terasology.gestalt.assets.format.AssetDataFile;
import org.terasology.gestalt.assets.management.AssetManager;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentManager;
import org.terasology.gestalt.entitysystem.component.management.ComponentType;
import org.terasology.gestalt.entitysystem.component.management.ComponentTypeIndex;
import org.terasology.gestalt.entitysystem.component.management.PropertyAccessor;
import org.terasology.gestalt.entitysystem.entity.AbstractNOPEntityRef;
import org.terasology.gestalt.entitysystem.entity.EntityRef;
import org.terasology.gestalt.entitysystem.entity.NullEntityRef;
import org.terasology.gestalt.entitysystem.prefab.EntityRecipe;
import org.terasology.gestalt.entitysystem.prefab.Prefab;
import org.terasology.gestalt.entitysystem.prefab.PrefabData;
import org.terasology.gestalt.entitysystem.prefab.PrefabRef;
import org.terasology.gestalt.naming.Name;
import org.terasology.gestalt.util.collection.TypeKeyedMap;

public class PrefabJsonFormat
extends AbstractAssetFileFormat<PrefabData> {
    public static final String DEFAULT_ROOT_ENTITY_NAME = "root";
    private static final Logger logger = LoggerFactory.getLogger(PrefabJsonFormat.class);
    private static final Name THIS = new Name("this");
    private final ComponentTypeIndex componentIndex;
    private final ComponentManager componentManager;
    private final AssetManager assetManager;
    private final Gson gson;
    private final ThreadLocal<Deque<PrefabLoader>> loaderStack = new ThreadLocal<Deque<PrefabLoader>>(){

        @Override
        protected Deque<PrefabLoader> initialValue() {
            return Queues.newArrayDeque();
        }
    };

    public PrefabJsonFormat(ComponentTypeIndex componentIndex, ComponentManager componentManager, AssetManager assetManager, GsonBuilder gsonBuilder) {
        super("json", new String[]{"prefab"});
        this.componentIndex = componentIndex;
        this.componentManager = componentManager;
        this.assetManager = assetManager;
        gsonBuilder.registerTypeAdapter(EntityRef.class, (Object)new EntityRefTypeHandler());
        this.gson = gsonBuilder.create();
    }

    /*
     * Exception decompiling
     */
    public PrefabData load(ResourceUrn urn, List<AssetDataFile> inputs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class PrefabLoader {
        public static final String INHERIT = "inherit";
        public static final String ENTITIES = "entities";
        public static final String ENTITY = "entity";
        public static final String ROOT = "root";
        private PrefabData prefabData;
        private ResourceUrn prefabUrn;

        private PrefabLoader() {
        }

        public PrefabData load(JsonObject prefabDataObject, ResourceUrn prefabUrn) throws IOException {
            this.prefabUrn = prefabUrn;
            this.prefabData = new PrefabData();
            if (prefabDataObject.has(INHERIT)) {
                this.inheritPrefab(prefabDataObject.getAsJsonPrimitive(INHERIT).getAsString());
            }
            if (prefabDataObject.has(ENTITIES)) {
                this.loadEntitiesFromJson(prefabUrn, prefabDataObject.getAsJsonObject(ENTITIES));
            } else if (prefabDataObject.has(ENTITY)) {
                this.loadEntityFromJson(prefabUrn, prefabDataObject.getAsJsonObject(ENTITY));
            } else {
                throw new IOException("Prefab file missing entity definition");
            }
            if (prefabDataObject.has("root")) {
                this.prefabData.setRootEntityId(new ResourceUrn(prefabUrn, prefabDataObject.getAsJsonPrimitive("root").getAsString()));
            } else if (this.prefabData.getRecipes().containsKey(new ResourceUrn(prefabUrn, "root"))) {
                this.prefabData.setRootEntityId(new ResourceUrn(prefabUrn, "root"));
            }
            return this.prefabData;
        }

        private void loadEntitiesFromJson(ResourceUrn prefabUrn, JsonObject entities) throws IOException {
            for (Map.Entry entry : entities.entrySet()) {
                this.addEntityRecipeIfMissing(new ResourceUrn(prefabUrn, (String)entry.getKey()));
            }
            for (Map.Entry entry : entities.entrySet()) {
                ResourceUrn entityUrn = new ResourceUrn(prefabUrn, (String)entry.getKey());
                this.loadEntityRecipe(this.prefabData.getRecipes().get(entityUrn), ((JsonElement)entry.getValue()).getAsJsonObject());
            }
        }

        private void loadEntityFromJson(ResourceUrn prefabUrn, JsonObject entity) throws IOException {
            ResourceUrn entityUrn = new ResourceUrn(prefabUrn, "root");
            this.addEntityRecipeIfMissing(entityUrn);
            this.loadEntityRecipe(this.prefabData.getRecipes().get(entityUrn), entity);
        }

        private void addEntityRecipeIfMissing(ResourceUrn entityUrn) {
            if (!this.prefabData.getRecipes().containsKey(entityUrn)) {
                this.prefabData.addEntityRecipe(new EntityRecipe(entityUrn));
            }
        }

        private void inheritPrefab(String parentPrefabUrn) throws IOException {
            Prefab parentPrefab = (Prefab)((Object)PrefabJsonFormat.this.assetManager.getAsset(parentPrefabUrn, Prefab.class).orElseThrow(() -> new IOException("Unable to resolve parent prefab " + parentPrefabUrn + " for prefab " + this.prefabUrn)));
            for (EntityRecipe recipe : parentPrefab.getEntityRecipes().values()) {
                final EntityRecipe copy = new EntityRecipe(new ResourceUrn(this.prefabUrn, recipe.getIdentifier().getFragmentName()));
                recipe.getComponents().forEach((TypeKeyedMap.EntryConsumer)new TypeKeyedMap.EntryConsumer<Component>(){

                    public <U extends Component> void accept(Class<U> type, U value) {
                        copy.add(PrefabJsonFormat.this.componentManager.copy(value));
                    }
                });
                this.prefabData.addEntityRecipe(copy);
            }
        }

        private void loadEntityRecipe(EntityRecipe entityRecipe, JsonObject entityPrefabData) throws IOException {
            for (Map.Entry componentData : entityPrefabData.entrySet()) {
                Class<? extends Component> componentClass = PrefabJsonFormat.this.componentIndex.find((String)componentData.getKey()).orElseThrow(() -> new IOException("Unable to resolve component '" + (String)componentData.getKey() + "'"));
                this.loadComponent(entityRecipe, componentClass, ((JsonElement)componentData.getValue()).getAsJsonObject());
            }
        }

        private <T extends Component<T>> void loadComponent(EntityRecipe entityRecipe, Class<T> componentClass, JsonObject value) {
            ComponentType type = PrefabJsonFormat.this.componentManager.getType(componentClass);
            Component component = entityRecipe.getComponent(componentClass).orElseGet(() -> {
                Object newComp = type.create();
                entityRecipe.add(newComp);
                return newComp;
            });
            type.getPropertyInfo().getProperties().entrySet().stream().filter(properties -> value.has((String)properties.getKey())).forEach(properties -> {
                PropertyAccessor propertyAccessor = (PropertyAccessor)properties.getValue();
                this.readProperty((String)properties.getKey(), value, component, propertyAccessor);
            });
        }

        private <T extends Component, U> void readProperty(String name, JsonObject value, T component, PropertyAccessor<T, U> propertyAccessor) {
            propertyAccessor.set(component, PrefabJsonFormat.this.gson.fromJson(value.get(name), propertyAccessor.getPropertyType()));
        }
    }

    private class EntityRefTypeHandler
    implements JsonDeserializer<EntityRef> {
        private EntityRefTypeHandler() {
        }

        public EntityRef deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String refString = json.getAsJsonPrimitive().getAsString();
            if (ResourceUrn.isValid((String)refString)) {
                return this.readUrnRef(refString);
            }
            return this.readSimpleRef(refString);
        }

        private EntityRef readSimpleRef(String refString) {
            PrefabLoader loader = (PrefabLoader)((Deque)PrefabJsonFormat.this.loaderStack.get()).peek();
            AbstractNOPEntityRef ref = null;
            EntityRecipe recipe = loader.prefabData.getRecipes().get(new ResourceUrn(loader.prefabUrn, refString));
            if (recipe != null) {
                ref = recipe.getReference();
            } else {
                Optional refPrefab = PrefabJsonFormat.this.assetManager.getAsset(refString, Prefab.class);
                if (refPrefab.isPresent()) {
                    ref = new PrefabRef((Prefab)((Object)refPrefab.get()));
                }
            }
            if (ref == null) {
                logger.error("Unable to resolve entity or prefab reference {}", (Object)refString);
                return NullEntityRef.get();
            }
            return ref;
        }

        private EntityRef readUrnRef(String refString) {
            ResourceUrn refUrn = new ResourceUrn(refString);
            if (THIS.equals((Object)refUrn.getModuleName())) {
                return this.readEntityRecipeRef(refUrn.getResourceName().toString());
            }
            Optional refPrefab = PrefabJsonFormat.this.assetManager.getAsset(refString, Prefab.class);
            if (refPrefab.isPresent()) {
                return new PrefabRef((Prefab)((Object)refPrefab.get()));
            }
            logger.error("Unable to resolve prefab reference {}", (Object)refString);
            return NullEntityRef.get();
        }

        private EntityRef readEntityRecipeRef(String refString) {
            PrefabLoader loader = (PrefabLoader)((Deque)PrefabJsonFormat.this.loaderStack.get()).peek();
            EntityRecipe recipe = loader.prefabData.getRecipes().get(new ResourceUrn(loader.prefabUrn, refString));
            if (recipe == null) {
                logger.error("Unable to resolve entity reference {}", (Object)refString);
                return NullEntityRef.get();
            }
            return recipe.getReference();
        }
    }

    public static class Builder {
        private final ComponentTypeIndex componentTypeIndex;
        private final ComponentManager componentManager;
        private AssetManager assetManager;
        private GsonBuilder gsonBuilder;

        public Builder(ComponentTypeIndex componentTypeIndex, ComponentManager componentManager, AssetManager assetManager) {
            this.componentTypeIndex = componentTypeIndex;
            this.componentManager = componentManager;
            this.assetManager = assetManager;
            this.gsonBuilder = new GsonBuilder().setLenient().enableComplexMapKeySerialization().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        }

        public Builder registerTypeAdapter(Type type, Object typeAdapter) {
            this.gsonBuilder.registerTypeAdapter(type, typeAdapter);
            return this;
        }

        public Builder registerTypeHierarchyAdapter(Class<?> type, Object typeAdapter) {
            this.gsonBuilder.registerTypeHierarchyAdapter(type, typeAdapter);
            return this;
        }

        public Builder registerTypeAdapterFactory(TypeAdapterFactory factory) {
            this.gsonBuilder.registerTypeAdapterFactory(factory);
            return this;
        }

        public PrefabJsonFormat create() {
            return new PrefabJsonFormat(this.componentTypeIndex, this.componentManager, this.assetManager, this.gsonBuilder);
        }
    }
}

