/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct GLFWvidmode")
public class GLFWVidMode
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int REDBITS;
    public static final int GREENBITS;
    public static final int BLUEBITS;
    public static final int REFRESHRATE;

    GLFWVidMode(long address, ByteBuffer container) {
        super(address, container);
    }

    public GLFWVidMode(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), GLFWVidMode.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return GLFWVidMode.nwidth(this.address());
    }

    public int height() {
        return GLFWVidMode.nheight(this.address());
    }

    public int redBits() {
        return GLFWVidMode.nredBits(this.address());
    }

    public int greenBits() {
        return GLFWVidMode.ngreenBits(this.address());
    }

    public int blueBits() {
        return GLFWVidMode.nblueBits(this.address());
    }

    public int refreshRate() {
        return GLFWVidMode.nrefreshRate(this.address());
    }

    public static GLFWVidMode create(long address) {
        return address == 0L ? null : new GLFWVidMode(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static int nredBits(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REDBITS));
    }

    public static int ngreenBits(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GREENBITS));
    }

    public static int nblueBits(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLUEBITS));
    }

    public static int nrefreshRate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFRESHRATE));
    }

    static {
        Struct.Layout layout = GLFWVidMode.__struct((Struct.Member[])new Struct.Member[]{GLFWVidMode.__member((int)4), GLFWVidMode.__member((int)4), GLFWVidMode.__member((int)4), GLFWVidMode.__member((int)4), GLFWVidMode.__member((int)4), GLFWVidMode.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        REDBITS = layout.offsetof(2);
        GREENBITS = layout.offsetof(3);
        BLUEBITS = layout.offsetof(4);
        REFRESHRATE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<GLFWVidMode, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected GLFWVidMode newInstance(long address) {
            return new GLFWVidMode(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public int width() {
            return GLFWVidMode.nwidth(this.address());
        }

        public int height() {
            return GLFWVidMode.nheight(this.address());
        }

        public int redBits() {
            return GLFWVidMode.nredBits(this.address());
        }

        public int greenBits() {
            return GLFWVidMode.ngreenBits(this.address());
        }

        public int blueBits() {
            return GLFWVidMode.nblueBits(this.address());
        }

        public int refreshRate() {
            return GLFWVidMode.nrefreshRate(this.address());
        }
    }
}

