/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter;

import java.awt.Dialog;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import javax.swing.JDialog;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.Resources;
import org.terasology.crashreporter.RootPanel;

public final class CrashReporter {
    private CrashReporter() {
    }

    public static void report(final Throwable throwable, final Path logFileFolder) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LookAndFeel oldLaF = UIManager.getLookAndFeel();
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    GlobalProperties properties = new GlobalProperties();
                    CrashReporter.showModalDialog(throwable, properties, logFileFolder);
                    try {
                        UIManager.setLookAndFeel(oldLaF);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected static void showModalDialog(Throwable throwable, GlobalProperties properties, Path logFolder) {
        String dialogTitle = I18N.getMessage("dialogTitle");
        String version = Resources.getVersion();
        if (version != null) {
            dialogTitle = dialogTitle + " " + version;
        }
        RootPanel panel = new RootPanel(throwable, properties, logFolder);
        JDialog dialog = new JDialog((Dialog)null, dialogTitle, true);
        dialog.setIconImage(Resources.loadImage(properties.get(GlobalProperties.KEY.RES_SERVER_ICON)));
        dialog.setContentPane(panel);
        dialog.setMinimumSize(new Dimension(600, 400));
        dialog.setLocationRelativeTo(null);
        dialog.setResizable(true);
        dialog.setVisible(true);
        dialog.dispose();
    }
}

