/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.terasology.crashreporter.CrashReporter;

public final class GlobalProperties {
    private final Properties properties = new Properties();

    public GlobalProperties() {
        Throwable throwable;
        InputStream stream;
        String propsUrl = "/crashreporter.properties";
        String defaultPropsUrl = "/crashreporter_defaults.properties";
        try {
            stream = CrashReporter.class.getResourceAsStream(defaultPropsUrl);
            throwable = null;
            try {
                this.properties.load(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Unable to load default properties");
        }
        try {
            stream = CrashReporter.class.getResourceAsStream(propsUrl);
            throwable = null;
            try {
                this.properties.load(stream);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Unable to load " + propsUrl);
        }
    }

    public String get(KEY key) {
        return this.properties.getProperty(key.name());
    }

    public static enum KEY {
        SUPPORT_FORUM_LINK,
        JOIN_IRC_LINK,
        REPORT_ISSUE_LINK,
        RES_BANNER_IMAGE,
        RES_SERVER_ICON,
        RES_ARROW_PREV,
        RES_ARROW_NEXT,
        RES_EXIT_ICON,
        RES_ERROR_TITLE_IMAGE,
        RES_INFO_TITLE_IMAGE,
        RES_PASTEBIN_ICON,
        RES_GDRIVE_ICON,
        RES_SKIP_UPLOAD_ICON,
        RES_COPY_ICON,
        RES_FINAL_TITLE_IMAGE,
        RES_UPLOAD_TITLE_IMAGE,
        RES_GITHUB_ICON,
        RES_IRC_ICON,
        RES_FORUM_ICON;

    }
}

