/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class I18N {
    private static final String MESSAGE_BUNDLE = "i18n.MessagesBundle";

    private I18N() {
    }

    public static String getMessage(String key) {
        Locale locale = Locale.getDefault();
        try {
            return ResourceBundle.getBundle(MESSAGE_BUNDLE, locale).getString(key);
        }
        catch (MissingResourceException e) {
            System.err.println("Missing message translation! key=" + key + ", locale=" + locale);
            return "$" + key + "$";
        }
    }

    public static String getMessage(String key, Object ... arguments) {
        Locale locale = Locale.getDefault();
        try {
            String pattern = ResourceBundle.getBundle(MESSAGE_BUNDLE, locale).getString(key);
            MessageFormat messageFormat = new MessageFormat(pattern, locale);
            return messageFormat.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (MissingResourceException e) {
            System.err.println("Missing message translation! key=" + key + ", locale=" + locale);
            return "$" + key + "$";
        }
    }
}

