/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class Resources {
    private Resources() {
    }

    public static BufferedImage loadImage(String fname) {
        try {
            String fullPath = "/" + fname;
            URL rsc = Resources.class.getResource(fullPath);
            if (rsc == null) {
                throw new FileNotFoundException(fullPath);
            }
            return ImageIO.read(rsc);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return Resources.createDummyImage(64, 64, "?");
        }
    }

    private static BufferedImage createDummyImage(int w, int h, String text) {
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        float[] dash = new float[]{5.0f, 5.0f};
        g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, w - 1, h - 1);
        g.setFont(g.getFont().deriveFont(1, 20.0f));
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        g.drawString(text, (w - textWidth) / 2, (h + fm.getAscent()) / 2);
        g.dispose();
        return img;
    }

    public static Icon loadIcon(String fname) {
        return new ImageIcon(Resources.loadImage(fname));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        String fname = "versionInfo.properties";
        URL location = Resources.class.getResource(fname);
        if (location == null) {
            return "";
        }
        try (InputStream is = location.openStream();){
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("displayVersion", "");
            return string;
        }
        catch (IOException e) {
            System.err.println("Error reading version info " + fname);
            e.printStackTrace();
            return "";
        }
    }
}

