/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.PageCompleteListener;
import org.terasology.crashreporter.Resources;
import org.terasology.crashreporter.pages.ErrorMessagePanel;
import org.terasology.crashreporter.pages.FinalActionsPanel;
import org.terasology.crashreporter.pages.UploadPanel;
import org.terasology.crashreporter.pages.UserInfoPanel;
import org.terasology.gui.JImage;
import org.terasology.gui.RXCardLayout;

public class RootPanel
extends JPanel {
    private static final long serialVersionUID = -907008390086125919L;

    public RootPanel(Throwable exception, GlobalProperties properties, Path logFolderFile) {
        this.setLayout(new BorderLayout());
        Font buttonFont = this.getFont().deriveFont(1, 14.0f);
        Icon prevIcon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_ARROW_PREV));
        final Icon nextIcon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_ARROW_NEXT));
        final Icon closeIcon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_EXIT_ICON));
        ArrayList<JPanel> pages = new ArrayList<JPanel>();
        ErrorMessagePanel errorMessagePanel = new ErrorMessagePanel(properties, exception, logFolderFile);
        pages.add(errorMessagePanel);
        final UserInfoPanel userInfoPanel = new UserInfoPanel(properties, errorMessagePanel.getLog(), errorMessagePanel.getLogFile());
        pages.add(userInfoPanel);
        final UploadPanel uploadPanel = new UploadPanel(properties, new Supplier<String>(){

            @Override
            public String get() {
                return userInfoPanel.getLog();
            }
        }, new Supplier<String>(){

            @Override
            public String get() {
                return userInfoPanel.getLogFile().toString();
            }
        });
        pages.add(uploadPanel);
        pages.add(new FinalActionsPanel(properties, new Supplier<URL>(){

            @Override
            public URL get() {
                return uploadPanel.getUploadedFileURL();
            }
        }));
        final JPanel mainPanel = new JPanel();
        final RXCardLayout cards = new RXCardLayout(5, 5);
        mainPanel.setLayout(cards);
        for (JComponent jComponent : pages) {
            mainPanel.add(jComponent);
        }
        JImage image = new JImage(Resources.loadImage(properties.get(GlobalProperties.KEY.RES_BANNER_IMAGE)));
        image.setBackground(new Color(20, 20, 10));
        image.setBorder(new MatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        this.add((Component)image, "West");
        this.add((Component)mainPanel, "Center");
        JPanel jPanel = new JPanel();
        MatteBorder lineBorder = new MatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY);
        jPanel.setBorder(BorderFactory.createCompoundBorder(lineBorder, new EmptyBorder(10, 25, 10, 25)));
        jPanel.setLayout(new GridLayout(1, 0, 200, 0));
        final JButton prevButton = new JButton(I18N.getMessage("prev"), prevIcon);
        final JButton nextButton = new JButton(I18N.getMessage("next"), nextIcon);
        for (JComponent jComponent : pages) {
            jComponent.addPropertyChangeListener("pageComplete", new PageCompleteListener(nextButton));
        }
        prevButton.setFont(buttonFont);
        prevButton.setHorizontalAlignment(2);
        prevButton.setEnabled(false);
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cards.isPreviousCardAvailable()) {
                    nextButton.setEnabled(true);
                    cards.previous(mainPanel);
                    prevButton.setEnabled(cards.isPreviousCardAvailable());
                    nextButton.setText(I18N.getMessage("next"));
                    nextButton.setIcon(nextIcon);
                }
            }
        });
        nextButton.setFont(buttonFont);
        nextButton.setHorizontalAlignment(4);
        nextButton.setHorizontalTextPosition(2);
        nextButton.setEnabled(cards.isNextCardAvailable());
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cards.isNextCardAvailable()) {
                    cards.next(mainPanel);
                    prevButton.setEnabled(true);
                    if (!cards.isNextCardAvailable()) {
                        nextButton.setText(I18N.getMessage("close"));
                        nextButton.setIcon(closeIcon);
                    }
                } else {
                    Window wnd = (Window)RootPanel.this.getTopLevelAncestor();
                    wnd.dispatchEvent(new WindowEvent(wnd, 201));
                }
            }
        });
        jPanel.add(prevButton);
        jPanel.add(nextButton);
        this.add((Component)jPanel, "South");
        ((JComponent)pages.get(0)).setVisible(true);
    }
}

