/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.logic;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.SecurityUtils;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.Permission;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GoogleDriveConnector {
    private static final String APPLICATION_NAME = "Terasology-GooeyDrive/1.0";
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private final HttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
    private final Drive drive;
    private final Credential credential = GoogleDriveConnector.authorize(this.httpTransport);

    public GoogleDriveConnector() throws GeneralSecurityException, IOException {
        this.drive = new Drive.Builder(this.httpTransport, JSON_FACTORY, (HttpRequestInitializer)this.credential).setApplicationName(APPLICATION_NAME).build();
    }

    public com.google.api.services.drive.model.File uploadFile(File file, boolean useDirectUpload) throws IOException {
        String contentType = null;
        FileContent mediaContent = new FileContent(contentType, file);
        return this.uploadFile((AbstractInputStreamContent)mediaContent, contentType, useDirectUpload);
    }

    public com.google.api.services.drive.model.File uploadFile(InputStream contentStream, String name, boolean useDirectUpload) throws IOException {
        String contentType = null;
        InputStreamContent content = new InputStreamContent(contentType, contentStream);
        return this.uploadFile((AbstractInputStreamContent)content, name, useDirectUpload);
    }

    public void setPermission(String fileId, String value, String type, String role) throws IOException {
        Permission newPermission = new Permission();
        newPermission.setValue(value);
        newPermission.setType(type);
        newPermission.setRole(role);
        this.drive.permissions().insert(fileId, newPermission).execute();
    }

    public void downloadToFile(com.google.api.services.drive.model.File file, File localFolder, boolean useDirectDownload) throws IOException {
        File localFile = new File(localFolder, file.getOriginalFilename());
        try (FileOutputStream out = new FileOutputStream(localFile);){
            HttpRequestInitializer initializer = this.drive.getRequestFactory().getInitializer();
            MediaHttpDownloader downloader = new MediaHttpDownloader(this.httpTransport, initializer);
            downloader.setDirectDownloadEnabled(useDirectDownload);
            downloader.download(new GenericUrl(file.getDownloadUrl()), (OutputStream)out);
        }
    }

    public com.google.api.services.drive.model.File getFileForID(String fileId) throws IOException {
        com.google.api.services.drive.model.File file = (com.google.api.services.drive.model.File)this.drive.files().get(fileId).execute();
        return file;
    }

    public List<com.google.api.services.drive.model.File> retrieveAllFiles() throws IOException {
        ArrayList<com.google.api.services.drive.model.File> result = new ArrayList<com.google.api.services.drive.model.File>();
        Drive.Files.List request = this.drive.files().list();
        String token = null;
        do {
            FileList files = (FileList)request.execute();
            result.addAll(files.getItems());
            token = files.getNextPageToken();
            request.setPageToken(token);
        } while (token != null && token.length() > 0);
        return result;
    }

    private static Credential authorize(HttpTransport httpTransport) throws GeneralSecurityException, IOException {
        PrivateKey serviceAccountPrivateKey = GoogleDriveConnector.getPrivateKey();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId("454164381957-9fnum5600ia5bp94jgkmbrrlhicjb1vo@developer.gserviceaccount.com").setServiceAccountScopes(Collections.singleton("https://www.googleapis.com/auth/drive")).setServiceAccountPrivateKey(serviceAccountPrivateKey).build();
        return credential;
    }

    private static PrivateKey getPrivateKey() throws IOException, GeneralSecurityException {
        URL website = new URL("http://jenkins.terasology.org/userContent/GooeyDrive-24506b2f1f34.p12");
        try (InputStream keyStream = website.openStream();){
            PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)keyStream, (String)"notasecret", (String)"privatekey", (String)"notasecret");
            return privateKey;
        }
    }

    private com.google.api.services.drive.model.File uploadFile(AbstractInputStreamContent content, String name, boolean useDirectUpload) throws IOException {
        com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
        fileMetadata.setTitle(name);
        Drive.Files.Insert insert = this.drive.files().insert(fileMetadata, content);
        MediaHttpUploader uploader = insert.getMediaHttpUploader();
        uploader.setDirectUploadEnabled(useDirectUpload);
        return (com.google.api.services.drive.model.File)insert.execute();
    }
}

