/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.pages;

import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.Resources;

public class ErrorMessagePanel
extends JPanel {
    private static final long serialVersionUID = 8449689452512733452L;
    private final JTabbedPane tabPane;
    private final List<JTextArea> textAreas = Lists.newArrayList();
    private final List<Path> logFiles;

    public ErrorMessagePanel(GlobalProperties properties, Throwable exception, Path logFileFolder) {
        ErrorMessagePanel mainPanel = this;
        mainPanel.setLayout(new BorderLayout(0, 5));
        String text = "<b>" + exception.getClass().getSimpleName() + "</b>";
        String exMessage = exception.getLocalizedMessage();
        if (exMessage != null) {
            text = text + ": " + exMessage;
        }
        text = text.replaceAll("\\r?\\n", "<br/>");
        String firstLine = I18N.getMessage("firstLine");
        Icon titleIcon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_ERROR_TITLE_IMAGE));
        String htmlText = "<html><h3>" + firstLine + "</h3>" + text + "</html>";
        JLabel message = new JLabel(htmlText, titleIcon, 2);
        mainPanel.add((Component)message, "North");
        this.logFiles = this.findLogs(logFileFolder);
        ErrorMessagePanel.sortLogFiles(this.logFiles);
        this.tabPane = new JTabbedPane();
        if (!this.logFiles.isEmpty()) {
            for (Path logFile : this.logFiles) {
                String logFileContent = ErrorMessagePanel.readLogFileContent(logFile);
                JTextArea logArea = new JTextArea();
                logArea.setText(logFileContent);
                String tabName = logFileFolder.relativize(logFile).toString();
                this.tabPane.addTab(tabName, new JScrollPane(logArea));
                this.textAreas.add(logArea);
            }
            this.add((Component)this.tabPane, "Center");
        } else {
            JLabel missingFilesLabel = new JLabel(I18N.getMessage("noLogFiles"), 0);
            missingFilesLabel.setFont(missingFilesLabel.getFont().deriveFont(1, 14.0f));
            missingFilesLabel.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)missingFilesLabel, "Center");
        }
        String readablePath = logFileFolder != null ? logFileFolder.toAbsolutePath().normalize().toString() : I18N.getMessage("notSpecified");
        String loc = I18N.getMessage("fileLocation") + ": " + readablePath;
        String editMessage = I18N.getMessage("editBeforeUpload");
        int idx = editMessage.indexOf(58);
        if (idx > 0) {
            editMessage = "<b>" + editMessage.substring(0, idx) + "</b>" + editMessage.substring(idx);
        }
        JLabel editHintLabel = new JLabel("<html>" + loc + "<br/><br/>" + editMessage + "</html>");
        this.add((Component)editHintLabel, "South");
    }

    private static void sortLogFiles(List<Path> files) {
        files.sort(new Comparator<Path>(){

            @Override
            public int compare(Path p0, Path p1) {
                try {
                    BasicFileAttributes attr0 = Files.readAttributes(p0, BasicFileAttributes.class, new LinkOption[0]);
                    BasicFileAttributes attr1 = Files.readAttributes(p1, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime time0 = attr0.creationTime();
                    FileTime time1 = attr1.creationTime();
                    return time0.compareTo(time1);
                }
                catch (Exception e) {
                    return 0;
                }
            }
        }.reversed());
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            return;
        }
        if (this.logFiles.isEmpty()) {
            this.firePropertyChange("pageComplete", true, false);
        }
    }

    private List<Path> findLogs(Path logFileFolder) {
        final ArrayList results = Lists.newArrayList();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".log")) {
                    results.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        if (logFileFolder != null) {
            try {
                Files.walkFileTree(logFileFolder, EnumSet.noneOf(FileVisitOption.class), 2, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public String getLog() {
        int idx = this.tabPane.getSelectedIndex();
        return idx >= 0 ? this.textAreas.get(idx).getText() : "";
    }

    public Path getLogFile() {
        int idx = this.tabPane.getSelectedIndex();
        return idx >= 0 ? this.logFiles.get(idx) : null;
    }

    private static String readLogFileContent(Path logFile) {
        StringBuilder builder = new StringBuilder();
        if (logFile != null) {
            try {
                List<String> lines = Files.readAllLines(logFile, Charset.defaultCharset());
                for (String line : lines) {
                    builder.append(line);
                    builder.append(System.lineSeparator());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                StringWriter sw = new StringWriter();
                builder.append("Could not open log file " + logFile.toString() + System.lineSeparator());
                e.printStackTrace(new PrintWriter(sw));
                builder.append(sw.toString());
            }
        }
        return builder.toString();
    }
}

