/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.pages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.Resources;

public class FinalActionsPanel
extends JPanel {
    private static final long serialVersionUID = 2639334979749507943L;
    private final Supplier<URL> uploadedFile;
    private final JTextArea linkText;
    private final JButton copyLinkButton;
    private boolean pageComplete;

    public FinalActionsPanel(final GlobalProperties properties, Supplier<URL> uploadedFile) {
        this.uploadedFile = uploadedFile;
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(new EmptyBorder(0, 10, 10, 10));
        String firstLine = I18N.getMessage("reportProblem");
        String htmlText = "<html><h3>" + firstLine + "</h3></html>";
        Icon titleIcon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_FINAL_TITLE_IMAGE));
        JLabel message = new JLabel(htmlText, titleIcon, 2);
        this.add((Component)message, "North");
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(0, 1, 0, 10));
        Font buttonFont = this.getFont().deriveFont(1).deriveFont(14.0f);
        JButton forumButton = new JButton(I18N.getMessage("gotoForum"));
        forumButton.setIcon(Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_FORUM_ICON)));
        forumButton.setFont(buttonFont);
        forumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinalActionsPanel.openInBrowser(properties.get(GlobalProperties.KEY.SUPPORT_FORUM_LINK));
                FinalActionsPanel.this.pageComplete = true;
                FinalActionsPanel.this.firePropertyChange("pageComplete", !FinalActionsPanel.this.pageComplete, FinalActionsPanel.this.pageComplete);
            }
        });
        forumButton.setToolTipText(properties.get(GlobalProperties.KEY.SUPPORT_FORUM_LINK));
        gridPanel.add(forumButton);
        JButton enterIrc = new JButton(I18N.getMessage("joinIrc"));
        enterIrc.setFont(buttonFont);
        enterIrc.setIcon(Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_IRC_ICON)));
        enterIrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinalActionsPanel.openInBrowser(properties.get(GlobalProperties.KEY.JOIN_IRC_LINK));
                FinalActionsPanel.this.pageComplete = true;
                FinalActionsPanel.this.firePropertyChange("pageComplete", !FinalActionsPanel.this.pageComplete, FinalActionsPanel.this.pageComplete);
            }
        });
        enterIrc.setToolTipText(properties.get(GlobalProperties.KEY.JOIN_IRC_LINK));
        gridPanel.add(enterIrc);
        JButton githubIssueButton = new JButton(I18N.getMessage("reportIssue"));
        githubIssueButton.setFont(buttonFont);
        githubIssueButton.setIcon(Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_GITHUB_ICON)));
        githubIssueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinalActionsPanel.openInBrowser(properties.get(GlobalProperties.KEY.REPORT_ISSUE_LINK));
                FinalActionsPanel.this.pageComplete = true;
                FinalActionsPanel.this.firePropertyChange("pageComplete", !FinalActionsPanel.this.pageComplete, FinalActionsPanel.this.pageComplete);
            }
        });
        githubIssueButton.setToolTipText(properties.get(GlobalProperties.KEY.REPORT_ISSUE_LINK));
        gridPanel.add(githubIssueButton);
        this.add((Component)gridPanel, "Center");
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BorderLayout(5, 0));
        JLabel linkLabel = new JLabel(I18N.getMessage("logFileUrl"));
        linkPanel.add((Component)linkLabel, "West");
        this.linkText = new JTextArea();
        this.linkText.setPreferredSize(new Dimension(250, 25));
        this.linkText.setBorder(BorderFactory.createEtchedBorder());
        this.linkText.setEditable(false);
        linkPanel.add((Component)this.linkText, "Center");
        this.copyLinkButton = new JButton(Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_COPY_ICON)));
        this.copyLinkButton.setToolTipText(I18N.getMessage("copyToClipboard"));
        this.copyLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection stringSelection = new StringSelection(FinalActionsPanel.this.linkText.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
        linkPanel.add((Component)this.copyLinkButton, "East");
        this.add((Component)linkPanel, "South");
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            return;
        }
        this.firePropertyChange("pageComplete", !this.pageComplete, this.pageComplete);
        URL log = this.uploadedFile.get();
        String text = log != null ? log.toString() : I18N.getMessage("noUploadLinkText");
        this.copyLinkButton.setEnabled(log != null);
        this.linkText.setText(text);
        this.linkText.setEnabled(log != null);
    }

    private static void openInBrowser(String url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

