/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.pages;

import com.google.api.services.drive.model.File;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import org.terasology.crashreporter.logic.GoogleDriveConnector;

public class GDriveUploadRunnable
implements Callable<URL> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
    private final String content;

    public GDriveUploadRunnable(String content) {
        this.content = content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL call() throws IOException {
        try {
            GoogleDriveConnector gdrive = new GoogleDriveConnector();
            String name = "terasology_" + DATE_FORMAT.format(new Date()) + ".log";
            byte[] data = this.content.getBytes(StandardCharsets.UTF_8);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
                File uploadedFile = gdrive.uploadFile(stream, name, true);
                gdrive.setPermission(uploadedFile.getId(), null, "anyone", "reader");
                URL uRL = new URL(uploadedFile.getWebContentLink());
                return uRL;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

