/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.pages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.Resources;
import org.terasology.crashreporter.pages.GDriveUploadRunnable;
import org.terasology.crashreporter.pages.PastebinUploadRunnable;

public class UploadPanel
extends JPanel {
    private static final long serialVersionUID = -8247883237201535146L;
    private JButton uploadPasteBinButton;
    private JButton uploadGDriveButton;
    private boolean isComplete;
    private URL uploadURL;
    private JLabel statusLabel;
    private final Supplier<String> textSupplier;
    private final Supplier<String> logFileNameSupplier;
    private JButton uploadSkipButton;
    private JLabel titleLabel;

    public UploadPanel(GlobalProperties properties, Supplier<String> logTextSupp, Supplier<String> logFileNameSupp) {
        this.textSupplier = logTextSupp;
        this.logFileNameSupplier = logFileNameSupp;
        this.setLayout(new BorderLayout(50, 20));
        this.statusLabel = new JLabel(I18N.getMessage("noUpload"), 4);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.statusLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.titleLabel = new JLabel(Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_UPLOAD_TITLE_IMAGE)), 0);
        this.titleLabel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.add((Component)this.titleLabel, "North");
        Font buttonFont = this.getFont().deriveFont(1).deriveFont(14.0f);
        JPanel hosterPanel = new JPanel(new GridLayout(0, 1, 0, 20));
        hosterPanel.setBorder(new EmptyBorder(0, 50, 0, 50));
        this.uploadPasteBinButton = new JButton("PasteBin", Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_PASTEBIN_ICON)));
        this.uploadPasteBinButton.setFont(buttonFont);
        this.uploadPasteBinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadPanel.this.statusLabel.setText(I18N.getMessage("waitForUpload"));
                UploadPanel.this.uploadPasteBinButton.setEnabled(false);
                UploadPanel.this.uploadGDriveButton.setEnabled(false);
                String text = (String)UploadPanel.this.textSupplier.get();
                UploadPanel.this.upload(new PastebinUploadRunnable(text));
            }
        });
        hosterPanel.add(this.uploadPasteBinButton);
        this.uploadGDriveButton = new JButton("Google Drive", Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_GDRIVE_ICON)));
        this.uploadGDriveButton.setFont(buttonFont);
        this.uploadGDriveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadPanel.this.statusLabel.setText(I18N.getMessage("waitForUpload"));
                UploadPanel.this.uploadGDriveButton.setEnabled(false);
                UploadPanel.this.uploadPasteBinButton.setEnabled(false);
                String text = (String)UploadPanel.this.textSupplier.get();
                UploadPanel.this.upload(new GDriveUploadRunnable(text));
            }
        });
        hosterPanel.add(this.uploadGDriveButton);
        this.uploadSkipButton = new JButton(I18N.getMessage("skipUpload"), Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_SKIP_UPLOAD_ICON)));
        this.uploadSkipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadPanel.this.uploadSkipButton.setEnabled(false);
                UploadPanel.this.firePropertyChange("pageComplete", Boolean.FALSE, Boolean.TRUE);
                UploadPanel.this.isComplete = true;
            }
        });
        this.uploadSkipButton.setFont(buttonFont);
        hosterPanel.add(this.uploadSkipButton);
        this.add((Component)hosterPanel, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            return;
        }
        this.firePropertyChange("pageComplete", !this.isComplete, this.isComplete);
        String fname = this.logFileNameSupplier.get();
        this.titleLabel.setText("<html><h3>" + I18N.getMessage("uploadLog2") + "</h3>" + fname + "</html>");
    }

    public URL getUploadedFileURL() {
        return this.uploadURL;
    }

    private void upload(final Callable<URL> callable) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    URL link = (URL)callable.call();
                    UploadPanel.this.uploadSuccess(link);
                }
                catch (Exception e) {
                    UploadPanel.this.uploadFailed(e);
                }
            }
        };
        Thread thread = new Thread(runnable, "Upload");
        thread.start();
    }

    private void updateStatus() {
        if (this.uploadURL != null) {
            String uploadText = I18N.getMessage("uploadComplete");
            this.statusLabel.setText(String.format("<html>%s <a href=\"%s\">%s</a></html>", uploadText, this.uploadURL, this.uploadURL));
            this.statusLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.statusLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    UploadPanel.openInBrowser(UploadPanel.this.uploadURL.toString());
                }
            });
        } else {
            this.statusLabel.setText(I18N.getMessage("noUpload"));
        }
    }

    private void uploadSuccess(final URL link) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UploadPanel.this.uploadURL = link;
                UploadPanel.this.updateStatus();
                UploadPanel.this.uploadSkipButton.setEnabled(false);
                UploadPanel.this.uploadGDriveButton.setEnabled(true);
                UploadPanel.this.uploadPasteBinButton.setEnabled(true);
                UploadPanel.this.firePropertyChange("pageComplete", Boolean.FALSE, Boolean.TRUE);
                UploadPanel.this.isComplete = true;
            }
        });
    }

    private void uploadFailed(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String uploadFailed = I18N.getMessage("uploadFailed");
                JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), uploadFailed, 0);
                UploadPanel.this.uploadGDriveButton.setEnabled(true);
                UploadPanel.this.uploadPasteBinButton.setEnabled(true);
                UploadPanel.this.updateStatus();
            }
        });
    }

    private static void openInBrowser(String url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

