/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.crashreporter.pages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.terasology.crashreporter.GlobalProperties;
import org.terasology.crashreporter.I18N;
import org.terasology.crashreporter.Resources;

public class UserInfoPanel
extends JPanel {
    private static final long serialVersionUID = -1714121731354180405L;
    private JLabel requestLabel;
    private final JTextArea userMessageArea;
    private JLabel statusLabel;
    private String log;
    private final Path logFile;

    public UserInfoPanel(GlobalProperties properties, String log, Path logFile) {
        this.log = log;
        this.logFile = logFile;
        this.setLayout(new BorderLayout(0, 5));
        String title = I18N.getMessage("additionalInfoTitle");
        String message = I18N.getMessage("additionalInfoMessage");
        String htmlText = "<html><h3>" + title + "</h3>" + message + "</html>";
        Icon icon = Resources.loadIcon(properties.get(GlobalProperties.KEY.RES_INFO_TITLE_IMAGE));
        this.requestLabel = new JLabel(htmlText, icon, 2);
        this.userMessageArea = new JTextArea();
        this.userMessageArea.setFont(this.getFont().deriveFont(0).deriveFont(12.0f));
        this.userMessageArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserInfoPanel.this.refreshStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserInfoPanel.this.refreshStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserInfoPanel.this.refreshStatus();
            }
        });
        JScrollPane areaScrollPane = new JScrollPane(this.userMessageArea);
        this.statusLabel = new JLabel(I18N.getMessage("additionalInfoStatus"), 4);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.statusLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add((Component)this.requestLabel, "North");
        this.add((Component)areaScrollPane, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    private boolean isEmpty() {
        return this.userMessageArea.getText().isEmpty();
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean empty;
        super.setVisible(aFlag);
        if (!aFlag) {
            return;
        }
        this.firePropertyChange("pageComplete", empty, !(empty = this.isEmpty()));
    }

    private void refreshStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean empty;
                UserInfoPanel.this.firePropertyChange("pageComplete", empty, !(empty = UserInfoPanel.this.isEmpty()));
                if (!empty) {
                    UserInfoPanel.this.statusLabel.setText(" ");
                } else {
                    UserInfoPanel.this.statusLabel.setText(I18N.getMessage("additionalInfoStatus"));
                }
            }
        });
    }

    public String getLog() {
        if (this.isEmpty()) {
            return this.log;
        }
        return "USER-GIVEN INFO:" + "\n" + this.userMessageArea.getText() + "\n\n" + "ERROR STACK TRACE:" + "\n" + this.log;
    }

    public Path getLogFile() {
        return this.logFile;
    }
}

