/*
 * Decompiled with CFR 0.152.
 */
package org.terasology.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public class RXCardLayout
extends CardLayout
implements HierarchyListener {
    private static final long serialVersionUID = 2501916791850952136L;
    private List<JComponent> cards = new ArrayList<JComponent>();
    private JComponent firstCard;
    private JComponent lastCard;
    private JComponent currentCard;
    private boolean isRequestFocusOnCard = true;
    private Action nextAction;
    private Action previousAction;

    public RXCardLayout() {
        this(0, 0);
    }

    public RXCardLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)comp;
        this.cards.add(component);
        if (this.firstCard == null) {
            this.firstCard = component;
        }
        this.lastCard = component;
        component.addHierarchyListener(this);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent component = (JComponent)comp;
        component.removeHierarchyListener(this);
        this.cards.remove(component);
        if (component.equals(this.firstCard) && this.cards.size() > 0) {
            this.firstCard = this.cards.get(0);
        }
        if (component.equals(this.lastCard) && this.cards.size() > 0) {
            this.lastCard = this.cards.get(this.cards.size() - 1);
        }
    }

    public JComponent getCurrentCard() {
        return this.currentCard;
    }

    public Action getNextAction() {
        return this.getNextAction("Next");
    }

    public Action getNextAction(String name) {
        if (this.nextAction == null) {
            this.nextAction = new CardAction(name, true);
            this.nextAction.putValue("MnemonicKey", name.charAt(0));
            this.nextAction.setEnabled(this.isNextCardAvailable());
        }
        return this.nextAction;
    }

    public Action getPreviousAction() {
        return this.getPreviousAction("Previous");
    }

    public Action getPreviousAction(String name) {
        if (this.previousAction == null) {
            this.previousAction = new CardAction(name, false);
            this.previousAction.putValue("MnemonicKey", name.charAt(0));
            this.previousAction.setEnabled(this.isNextCardAvailable());
        }
        return this.previousAction;
    }

    public boolean isNextCardAvailable() {
        return this.currentCard != this.lastCard;
    }

    public boolean isPreviousCardAvailable() {
        return this.currentCard != this.firstCard;
    }

    public boolean isRequestFocusOnCard() {
        return this.isRequestFocusOnCard;
    }

    public void setRequestFocusOnCard(boolean requestFocusOnCard) {
        this.isRequestFocusOnCard = requestFocusOnCard;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        JComponent component = (JComponent)e.getSource();
        if ((4L & e.getChangeFlags()) != 0L && component.isShowing()) {
            this.currentCard = component;
            if (this.isRequestFocusOnCard) {
                this.currentCard.transferFocus();
            }
            if (this.nextAction != null) {
                this.nextAction.setEnabled(this.isNextCardAvailable());
            }
            if (this.previousAction != null) {
                this.previousAction.setEnabled(this.isPreviousCardAvailable());
            }
        }
    }

    private class CardAction
    extends AbstractAction {
        private static final long serialVersionUID = 9163807372237454324L;
        private boolean isNext;

        CardAction(String text, boolean isNext) {
            super(text);
            this.isNext = isNext;
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent = RXCardLayout.this.getCurrentCard().getParent();
            if (this.isNext) {
                RXCardLayout.this.next(parent);
            } else {
                RXCardLayout.this.previous(parent);
            }
        }
    }
}

