/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jemalloc.MallocMessageCallbackI;

public abstract class MallocMessageCallback
extends Callback
implements MallocMessageCallbackI {
    public static MallocMessageCallback create(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        MallocMessageCallbackI instance = (MallocMessageCallbackI)Callback.get((long)functionPointer);
        return instance instanceof MallocMessageCallback ? (MallocMessageCallback)instance : new Container(functionPointer, instance);
    }

    public static MallocMessageCallback create(MallocMessageCallbackI instance) {
        return instance instanceof MallocMessageCallback ? (MallocMessageCallback)instance : new Container(instance.address(), instance);
    }

    protected MallocMessageCallback() {
        super("(pp)v");
    }

    private MallocMessageCallback(long functionPointer) {
        super(functionPointer);
    }

    public static String getMessage(long s) {
        return MemoryUtil.memASCII((long)s);
    }

    private static final class Container
    extends MallocMessageCallback {
        private final MallocMessageCallbackI delegate;

        Container(long functionPointer, MallocMessageCallbackI delegate) {
            super(functionPointer);
            this.delegate = delegate;
        }

        @Override
        public void invoke(long cbopaque, long s) {
            this.delegate.invoke(cbopaque, s);
        }
    }
}

