/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.abilities;

import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class PlanetTunnelAbility
implements ShipAbility {
    private final PlanetTunnelAbilityConfig config;
    private StarPort.Transcendent transcendentHero;
    private SolShip originalHero;

    public PlanetTunnelAbility(PlanetTunnelAbilityConfig config) {
        this.config = config;
    }

    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        Hero hero = game.getHero();
        if (tryToUse && !hero.isTranscendent()) {
            Planet nearestPlanet = game.getPlanetManager().getNearestPlanet();
            this.transcendentHero = new StarPort.Transcendent(owner, nearestPlanet, nearestPlanet, game);
            this.originalHero = hero.getShip();
            hero.setTranscendent(this.transcendentHero);
            return true;
        }
        if (this.transcendentHero != null && hero.isTranscendent()) {
            this.transcendentHero.update(game);
        }
        if (!hero.isTranscendent() && this.originalHero != null) {
            game.getObjectManager().removeObjDelayed((SolObject)this.originalHero);
            this.originalHero = null;
        }
        return false;
    }

    public AbilityConfig getConfig() {
        return this.config;
    }

    public AbilityCommonConfig getCommonConfig() {
        return this.config.commonConfig;
    }

    public float getRadius() {
        return Float.MAX_VALUE;
    }

    public static class PlanetTunnelAbilityConfig
    implements AbilityConfig {
        private final float rechargeTime;
        private final AbilityCommonConfig commonConfig;

        public PlanetTunnelAbilityConfig(float rechargeTime, AbilityCommonConfig commonConfig) {
            this.rechargeTime = rechargeTime;
            this.commonConfig = commonConfig;
        }

        public ShipAbility build() {
            return new PlanetTunnelAbility(this);
        }

        public SolItem getChargeExample() {
            return null;
        }

        public float getRechargeTime() {
            return this.rechargeTime;
        }

        public void appendDesc(StringBuilder sb) {
            sb.append("Transports the ship to the nearest planet via the most direct route.");
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = abNode.getFloat("rechargeTime");
            return new PlanetTunnelAbilityConfig(rechargeTime, cc);
        }
    }
}

