/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.abilities;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.Guardian;
import org.destinationsol.game.input.MoveDestProvider;
import org.destinationsol.game.input.Pilot;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONObject;

public class SummonMercenariesAbility
implements ShipAbility {
    private final SummonMercenariesAbilityConfig config;
    private float summonTimer;
    private SolShip[] mercenaries;
    private MercItem mercenary;

    public SummonMercenariesAbility(SummonMercenariesAbilityConfig config) {
        this.config = config;
        this.mercenaries = new SolShip[config.mercenaryCount];
    }

    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (this.mercenary == null) {
            this.mercenary = new MercItem(new ShipConfig(game.getHullConfigManager().getConfig(this.config.mercenaryName), this.config.mercenaryItems, 0, 1.0f, null, game.getItemMan(), ""));
        }
        if (tryToUse) {
            this.clearMercenaries(game);
            this.summonTimer = this.config.summonDuration;
            for (int mercenaryNo = 0; mercenaryNo < this.config.mercenaryCount; ++mercenaryNo) {
                ShipConfig mercConfig = this.mercenary.getConfig();
                Guardian guardian = new Guardian(game, mercConfig.hull, owner.getPilot(), owner.getPosition(), owner.getHull().config, SolRandom.randomFloat((float)180.0f));
                AiPilot pilot = new AiPilot((MoveDestProvider)guardian, true, owner.getPilot().getFaction(), false, "Merc", 5.4f);
                Vector2 position = SummonMercenariesAbility.getPos(game, owner, mercConfig.hull);
                if (position == null) {
                    return false;
                }
                SolShip merc = game.getShipBuilder().buildNewFar(game, position, new Vector2(), 0.0f, 0.0f, (Pilot)pilot, mercConfig.items, mercConfig.hull, null, true, (float)mercConfig.money, null, true).toObject(game);
                merc.setMerc(this.mercenary);
                this.mercenary.setSolShip(merc);
                game.getObjectManager().addObjDelayed((SolObject)merc);
                this.mercenaries[mercenaryNo] = merc;
            }
            return true;
        }
        if (this.summonTimer <= 0.0f) {
            this.clearMercenaries(game);
            return false;
        }
        this.summonTimer -= game.getTimeStep();
        return false;
    }

    private static Vector2 getPos(SolGame game, SolShip ship, HullConfig hull) {
        Vector2 position = new Vector2();
        float dist = ship.getHull().config.getApproxRadius() + 1.5f + hull.getApproxRadius();
        Vector2 heroPos = ship.getPosition();
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet(heroPos);
        boolean nearGround = nearestPlanet.isNearGround(heroPos);
        float fromPlanet = SolMath.angle((Vector2)nearestPlanet.getPosition(), (Vector2)heroPos);
        for (int i = 0; i < 50; ++i) {
            float relAngle = nearGround ? fromPlanet : (float)SolRandom.randomInt((int)180);
            SolMath.fromAl((Vector2)position, (float)relAngle, (float)dist);
            position.add(heroPos);
            if (game.isPlaceEmpty(position, false)) {
                return position;
            }
            dist += 1.5f;
        }
        return null;
    }

    private void clearMercenaries(SolGame game) {
        for (int mercenaryNo = 0; mercenaryNo < this.config.mercenaryCount; ++mercenaryNo) {
            if (this.mercenaries[mercenaryNo] == null) continue;
            this.mercenaries[mercenaryNo].getItemContainer().clear();
            this.mercenaries[mercenaryNo].receiveDmg(this.mercenaries[mercenaryNo].getLife() + 1.0f, game, this.mercenaries[mercenaryNo].getPosition(), DmgType.ENERGY);
        }
    }

    public AbilityConfig getConfig() {
        return this.config;
    }

    public AbilityCommonConfig getCommonConfig() {
        return this.config.getCommonConfig();
    }

    public float getRadius() {
        return Float.MAX_VALUE;
    }

    public static class SummonMercenariesAbilityConfig
    implements AbilityConfig {
        private final float rechargeTime;
        private final float summonDuration;
        private String mercenaryName;
        private final int mercenaryCount;
        private String mercenaryItems;
        private final AbilityCommonConfig commonConfig;

        public SummonMercenariesAbilityConfig(float rechargeTime, float summonDuration, String mercenaryName, int mercenaryCount, String mercenaryItems, AbilityCommonConfig commonConfig) {
            this.rechargeTime = rechargeTime;
            this.summonDuration = summonDuration;
            this.commonConfig = commonConfig;
            this.mercenaryName = mercenaryName;
            this.mercenaryItems = mercenaryItems;
            this.mercenaryCount = mercenaryCount;
        }

        public ShipAbility build() {
            return new SummonMercenariesAbility(this);
        }

        public SolItem getChargeExample() {
            return null;
        }

        public float getRechargeTime() {
            return this.rechargeTime;
        }

        public AbilityCommonConfig getCommonConfig() {
            return this.commonConfig;
        }

        public void appendDesc(StringBuilder sb) {
            sb.append("Summons some mercenaries to aid the ship.");
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = abNode.getFloat("rechargeTime");
            float summonDuration = abNode.getFloat("summonDuration");
            String mercenaryType = abNode.getString("mercenary");
            String mercenaryItems = abNode.getString("mercenaryItems");
            int mercenaryCount = abNode.getInt("mercenaryCount");
            return new SummonMercenariesAbilityConfig(rechargeTime, summonDuration, mercenaryType, mercenaryCount, mercenaryItems, cc);
        }
    }
}

