/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.abilities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.Collections;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.AbilityCommonConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.DrawableObject;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.ship.AbilityConfig;
import org.destinationsol.game.ship.ShipAbility;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class WarpShieldAbility
implements ShipAbility {
    private static final float SHIELD_TRANSPARENCY = 0.2f;
    private final WarpShieldAbilityConfig config;
    private Shield originalShield;
    private float shieldTimer;

    public WarpShieldAbility(WarpShieldAbilityConfig config) {
        this.config = config;
    }

    public boolean update(SolGame game, SolShip owner, boolean tryToUse) {
        if (tryToUse) {
            this.originalShield = owner.getShield();
            this.shieldTimer = this.config.shieldDuration;
            return true;
        }
        if (this.shieldTimer <= 0.0f || owner.shouldBeRemoved(game)) {
            owner.getItemContainer().remove((SolItem)this.config.warpShield);
            if (this.originalShield != null) {
                owner.maybeEquip(game, (SolItem)this.originalShield, true);
                this.originalShield = null;
            }
            return false;
        }
        boolean warpShieldPresent = false;
        for (int i = 0; i < owner.getItemContainer().groupCount(); ++i) {
            for (SolItem item : owner.getItemContainer().getGroup(i)) {
                if (item != this.config.warpShield) continue;
                warpShieldPresent = true;
            }
        }
        if (!warpShieldPresent) {
            owner.getItemContainer().add((SolItem)this.config.warpShield);
            owner.maybeEquip(game, (SolItem)this.config.warpShield, true);
        }
        owner.maybeEquip(game, (SolItem)this.config.warpShield, true);
        RectSprite shieldSprite = new RectSprite(this.config.warpShieldTex, owner.getHull().config.getSize() * 0.7f * 2.0f, 0.0f, 0.0f, new Vector2(), DrawableLevel.PART_FG_0, 0.0f, 0.0f, Color.WHITE, true);
        game.getObjectManager().addObjDelayed((SolObject)new DrawableObject(Collections.singletonList(shieldSprite), owner.getPosition(), new Vector2(), null, true, false));
        this.shieldTimer -= game.getTimeStep();
        return false;
    }

    public AbilityConfig getConfig() {
        return this.config;
    }

    public AbilityCommonConfig getCommonConfig() {
        return this.config.getCommonConfig();
    }

    public float getRadius() {
        return Float.MAX_VALUE;
    }

    public static class WarpShieldAbilityConfig
    implements AbilityConfig {
        private final float rechargeTime;
        private final float shieldDuration;
        private final Shield warpShield;
        private final TextureAtlas.AtlasRegion warpShieldTex;
        private final AbilityCommonConfig commonConfig;

        public WarpShieldAbilityConfig(float rechargeTime, float shieldDuration, Shield warpShield, TextureAtlas.AtlasRegion warpShieldTex, AbilityCommonConfig commonConfig) {
            this.rechargeTime = rechargeTime;
            this.shieldDuration = shieldDuration;
            this.commonConfig = commonConfig;
            this.warpShield = warpShield;
            this.warpShieldTex = warpShieldTex;
        }

        public ShipAbility build() {
            return new WarpShieldAbility(this);
        }

        public SolItem getChargeExample() {
            return null;
        }

        public float getRechargeTime() {
            return this.rechargeTime;
        }

        public AbilityCommonConfig getCommonConfig() {
            return this.commonConfig;
        }

        public void appendDesc(StringBuilder sb) {
            sb.append("Activates the ship's warp shield, which redirects all projectiles in normal space around it.");
        }

        public static AbilityConfig load(JSONObject abNode, ItemManager itemManager, AbilityCommonConfig cc) {
            float rechargeTime = abNode.getFloat("rechargeTime");
            float shieldDuration = abNode.getFloat("shieldDuration");
            String warpShieldName = abNode.getString("shield");
            String warpShieldTexName = abNode.optString("shieldTex", warpShieldName);
            itemManager.parseItems(warpShieldName);
            TextureAtlas.AtlasRegion warpShieldTex = null;
            try {
                warpShieldTex = Assets.getAtlasRegion((String)warpShieldTexName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Shield shield = (Shield)itemManager.getExample(warpShieldName);
            return new WarpShieldAbilityConfig(rechargeTime, shieldDuration, shield, warpShieldTex, cc);
        }
    }
}

