/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.actions;

import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.warp.research.ResearchAction;

public class PlanetResearchAction
implements ResearchAction {
    private static final float DEFAULT_PLANET_YIELD = 0.5f;
    private static final float DEFAULT_PLANET_YIELD_MAX = 120.0f;
    private final Planet planetToResearch;
    private float research;

    public PlanetResearchAction(Planet planetToResearch) {
        this.planetToResearch = planetToResearch;
    }

    @Override
    public float getMaxYield() {
        return 120.0f * (float)(this.planetToResearch.getSystem().getConfig().hard ? 2 : 1);
    }

    @Override
    public float doResearch(SolGame game, SolShip researchShip) {
        if (this.isResearchComplete()) {
            return 0.0f;
        }
        if (this.planetToResearch.isNearGround(researchShip.getPosition())) {
            float researchPoints = 0.5f * (float)(this.planetToResearch.getSystem().getConfig().hard ? 2 : 1) * game.getTimeStep();
            this.research += researchPoints;
            return researchPoints;
        }
        return 0.0f;
    }

    @Override
    public boolean isResearchComplete() {
        return this.research >= this.getMaxYield();
    }

    @Override
    public String getObjective() {
        return "Study " + this.planetToResearch.getName() + " in " + this.planetToResearch.getSystem().getName() + " " + Integer.toString((int)this.research) + "/" + Integer.toString((int)this.getMaxYield());
    }

    @Override
    public String getDescription() {
        return "Land on " + this.planetToResearch.getName() + " in " + this.planetToResearch.getSystem().getName() + " and explore. The research will automatically accumulate when near the planet's surface.";
    }
}

