/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.actions;

import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.warp.research.ResearchAction;

public class SolarResearchAction
implements ResearchAction {
    private static final float SOLAR_YIELD = 6.0f;
    private static final float RESEARCH_DISTANCE_RATE = 0.06f;
    private final SolSystem solarSystem;
    private float currentSolarYield;

    public SolarResearchAction(SolSystem solarSystem) {
        this.solarSystem = solarSystem;
    }

    @Override
    public float getMaxYield() {
        return 200.0f;
    }

    @Override
    public float doResearch(SolGame game, SolShip researchShip) {
        if (this.isResearchComplete()) {
            return 0.0f;
        }
        float research = 6.0f / (this.solarSystem.getPosition().dst(researchShip.getPosition()) * 0.06f) * game.getTimeStep();
        this.currentSolarYield += research;
        return research;
    }

    @Override
    public boolean isResearchComplete() {
        return this.currentSolarYield >= this.getMaxYield();
    }

    @Override
    public String getObjective() {
        return "Study the sun of " + this.solarSystem.getName() + " " + Integer.toString((int)this.currentSolarYield) + "/" + Integer.toString((int)this.getMaxYield());
    }

    @Override
    public String getDescription() {
        return "Get as close to the sun in the " + this.solarSystem.getName() + " system. The closer you get, the quicker this can be researched.";
    }
}

