/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.providers;

import java.util.HashMap;
import java.util.Map;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.warp.research.ResearchAction;
import org.destinationsol.warp.research.ResearchProvider;
import org.destinationsol.warp.research.actions.PlanetResearchAction;

public class PlanetResearchProvider
implements ResearchProvider {
    private Map<Planet, ResearchAction> planetResearchMap = new HashMap<Planet, ResearchAction>();

    @Override
    public boolean canProvideResearch(SolGame game, SolShip researchShip) {
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet(researchShip.getPosition());
        if (!nearestPlanet.isNearGround(researchShip.getPosition())) {
            return false;
        }
        if (this.planetResearchMap.containsKey(nearestPlanet)) {
            return !this.planetResearchMap.get(nearestPlanet).isResearchComplete();
        }
        return true;
    }

    @Override
    public ResearchAction getAction(SolGame game, SolShip researchShip) {
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet(researchShip.getPosition());
        if (!this.planetResearchMap.containsKey(nearestPlanet)) {
            this.planetResearchMap.put(nearestPlanet, new PlanetResearchAction(nearestPlanet));
        }
        return this.planetResearchMap.get(nearestPlanet);
    }

    @Override
    public ResearchAction[] getDiscoveredActions() {
        return this.planetResearchMap.values().toArray(new ResearchAction[0]);
    }
}

