/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.providers;

import java.util.HashMap;
import java.util.Map;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.warp.research.ResearchAction;
import org.destinationsol.warp.research.ResearchProvider;
import org.destinationsol.warp.research.actions.SolarResearchAction;

public class SolarResearchProvider
implements ResearchProvider {
    private Map<SolSystem, ResearchAction> solarResearchMap = new HashMap<SolSystem, ResearchAction>();

    @Override
    public boolean canProvideResearch(SolGame game, SolShip researchShip) {
        boolean isNearToSun;
        SolSystem nearestSystem = game.getPlanetManager().getNearestSystem(researchShip.getPosition());
        float sunDistance = nearestSystem.getPosition().dst(researchShip.getPosition());
        boolean bl = isNearToSun = sunDistance < 78.0f;
        if (!isNearToSun) {
            return false;
        }
        if (this.solarResearchMap.containsKey(nearestSystem)) {
            return !this.solarResearchMap.get(nearestSystem).isResearchComplete();
        }
        return true;
    }

    @Override
    public ResearchAction getAction(SolGame game, SolShip researchShip) {
        ResearchAction researchAction;
        if (!this.canProvideResearch(game, researchShip)) {
            return null;
        }
        SolSystem nearestSystem = game.getPlanetManager().getNearestSystem(researchShip.getPosition());
        if (!this.solarResearchMap.containsKey(nearestSystem)) {
            researchAction = new SolarResearchAction(nearestSystem);
            this.solarResearchMap.put(nearestSystem, researchAction);
        } else {
            researchAction = this.solarResearchMap.get(nearestSystem);
        }
        if (researchAction.isResearchComplete()) {
            return null;
        }
        return researchAction;
    }

    @Override
    public ResearchAction[] getDiscoveredActions() {
        return this.solarResearchMap.values().toArray(new ResearchAction[0]);
    }
}

