/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.systems;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.attributes.RegisterUpdateSystem;
import org.destinationsol.game.screens.MainGameScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolUiScreen;
import org.destinationsol.warp.research.ResearchAction;
import org.destinationsol.warp.research.ResearchProvider;
import org.destinationsol.warp.research.providers.PlanetResearchProvider;
import org.destinationsol.warp.research.providers.SolarResearchProvider;
import org.destinationsol.warp.research.uiScreens.ResearchOverlayUiScreen;

@RegisterUpdateSystem
public class ResearchSystem
implements UpdateAwareSystem {
    private static final String RESEARCH_POINT_ICON_PATH = "warp:researchPointIcon";
    private static final String[] DEFAULT_RESEARCH_SHIPS = new String[]{"warp:scout"};
    private static final ResearchProvider[] DEFAULT_RESEARCH_PROVIDERS = new ResearchProvider[]{new PlanetResearchProvider(), new SolarResearchProvider()};
    private static final float RESEARCH_EXCHANGE_RATE = 4.0f;
    private static List<String> researchShips = new ArrayList<String>();
    private static List<ResearchProvider> researchProviders;
    private float researchPoints;
    private ResearchOverlayUiScreen researchOverlayUi;

    public ResearchSystem() {
        TextureAtlas.AtlasRegion researchPointIcon = Assets.getAtlasRegion((String)RESEARCH_POINT_ICON_PATH);
    }

    public void update(SolGame game, float timeStep) {
        Hero hero;
        if (game.getHero().isDead()) {
            return;
        }
        if (this.researchOverlayUi == null) {
            this.researchOverlayUi = new ResearchOverlayUiScreen(this);
        }
        SolApplication application = game.getSolApplication();
        if (this.researchOverlayUi != null && application.getInputManager().getTopScreen() instanceof MainGameScreen && !game.getScreens().mainGameScreen.hasOverlay((SolUiScreen)this.researchOverlayUi)) {
            game.getScreens().mainGameScreen.addOverlayScreen((SolUiScreen)this.researchOverlayUi);
        }
        if (!(hero = game.getHero()).isTranscendent() && researchShips.contains(hero.getShip().getHull().getHullConfig().getInternalName())) {
            SolShip researchShip = hero.getShip();
            for (ResearchProvider provider : researchProviders) {
                ResearchAction action;
                if (!provider.canProvideResearch(game, researchShip) || (action = provider.getAction(game, researchShip)) == null) continue;
                this.researchPoints += action.doResearch(game, researchShip);
            }
        }
    }

    public float getResearchPoints() {
        return this.researchPoints;
    }

    public static void addResearchShip(String shipName) {
        if (researchShips.contains(shipName)) {
            return;
        }
        researchShips.add(shipName);
    }

    public static void addResearchProvider(ResearchProvider provider) {
        if (researchProviders.contains(provider)) {
            return;
        }
        researchProviders.add(provider);
    }

    public static ResearchProvider[] getResearchProviders() {
        return researchProviders.toArray(new ResearchProvider[0]);
    }

    public void sellResearchPoints(Hero hero, float points) {
        this.researchPoints -= MathUtils.clamp((float)points, (float)0.0f, (float)this.researchPoints);
        hero.setMoney(hero.getMoney() + points * 4.0f);
    }

    static {
        for (String defaultShip : DEFAULT_RESEARCH_SHIPS) {
            ResearchSystem.addResearchShip(defaultShip);
        }
        researchProviders = new ArrayList<ResearchProvider>();
        for (ResearchProvider provider : DEFAULT_RESEARCH_PROVIDERS) {
            ResearchSystem.addResearchProvider(provider);
        }
    }
}

