/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.systems;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.attributes.RegisterUpdateSystem;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.ship.ForceBeacon;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.HullConfig;

@RegisterUpdateSystem
public class WormholeDistortionProvider
implements UpdateAwareSystem {
    private static final String WORMHOLE_TEXTURE_PATH = "warp:distortionProjectile";
    private static final int WORMHOLE_MIN = 4000;
    private static final int WORMHOLE_MAX = 8000;
    private final TextureAtlas.AtlasRegion wormholeTexture;
    private List<DistortionObject> wormholes = new ArrayList<DistortionObject>();

    public WormholeDistortionProvider() {
        this.wormholeTexture = Assets.getAtlasRegion((String)WORMHOLE_TEXTURE_PATH);
    }

    public void update(SolGame game, float timeStep) {
        if (this.wormholes.isEmpty()) {
            Vector2 worldExtentsMin = new Vector2();
            Vector2 worldExtentsMax = new Vector2();
            for (SolSystem system : game.getPlanetManager().getSystems()) {
                Vector2 systemPosition = system.getPosition();
                if (systemPosition.x < worldExtentsMin.x) {
                    worldExtentsMin.x = systemPosition.x - system.getRadius();
                } else if (systemPosition.x > worldExtentsMax.x) {
                    worldExtentsMax.x = systemPosition.x;
                }
                if (systemPosition.y < worldExtentsMin.y) {
                    worldExtentsMin.y = systemPosition.y - system.getRadius();
                    continue;
                }
                if (!(systemPosition.y > worldExtentsMax.y)) continue;
                worldExtentsMax.y = systemPosition.y;
            }
            for (int i = 0; i < SolRandom.seededRandomInt((int)4000, (int)8000); ++i) {
                float targetValueY;
                float targetValueX;
                Vector2 targetPosition;
                float positionValueY;
                float positionValueX;
                Vector2 position;
                while (!game.isPlaceEmpty(position = new Vector2(positionValueX = SolRandom.seededRandomFloat((float)worldExtentsMin.x, (float)worldExtentsMax.x), positionValueY = SolRandom.seededRandomFloat((float)worldExtentsMin.y, (float)worldExtentsMax.y)), true)) {
                }
                while (!game.isPlaceEmpty(targetPosition = new Vector2(targetValueX = SolRandom.seededRandomFloat((float)worldExtentsMin.x, (float)worldExtentsMax.x), targetValueY = SolRandom.seededRandomFloat((float)worldExtentsMin.y, (float)worldExtentsMax.y)), true) && targetPosition.dst(position) > 10.0f) {
                }
                DistortionObject entryWormhole = new DistortionObject(position, targetPosition, 10.0f);
                this.wormholes.add(entryWormhole);
                game.getObjectManager().addObjDelayed((SolObject)entryWormhole);
                DistortionObject exitWormhole = new DistortionObject(targetPosition, position, 10.0f);
                this.wormholes.add(exitWormhole);
                game.getObjectManager().addObjDelayed((SolObject)exitWormhole);
            }
        }
    }

    private class DistortionObject
    implements SolObject {
        private final Vector2 wormholePosition;
        private final Vector2 target;
        private final List<Drawable> drawables = new ArrayList<Drawable>();
        private float wormholeStability;

        public DistortionObject(Vector2 wormholePosition, Vector2 target, float stability) {
            this.wormholePosition = wormholePosition;
            this.target = target;
            this.wormholeStability = stability;
            this.drawables.add((Drawable)new RectSprite(WormholeDistortionProvider.this.wormholeTexture, 1.0f, 0.0f, 0.0f, Vector2.Zero, DrawableLevel.PART_FG_0, 0.0f, 0.0f, Color.WHITE, false));
        }

        public void update(SolGame game) {
            SolShip approachingShip = ForceBeacon.pullShips((SolGame)game, (SolObject)this, (Vector2)this.wormholePosition, null, null, (float)0.7f);
            if (approachingShip != null && approachingShip.getHull().getHullConfig().getType() != HullConfig.Type.STATION && approachingShip.getPosition().dst(this.wormholePosition) < 0.1f) {
                approachingShip.getHull().getBody().setTransform(this.target, 0.0f);
            }
        }

        public boolean shouldBeRemoved(SolGame game) {
            return false;
        }

        public void onRemove(SolGame game) {
        }

        public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
            if (dmgType == DmgType.ENERGY) {
                this.wormholeStability -= dmg;
            }
        }

        public boolean receivesGravity() {
            return false;
        }

        public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        }

        public Vector2 getPosition() {
            return this.wormholePosition;
        }

        public FarObject toFarObject() {
            return new FarDistortionObject(this.wormholePosition, this.target, this.wormholeStability);
        }

        public List<Drawable> getDrawables() {
            return this.drawables;
        }

        public float getAngle() {
            return 0.0f;
        }

        public Vector2 getVelocity() {
            return Vector2.Zero;
        }

        public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
        }

        public Boolean isMetal() {
            return false;
        }

        public boolean hasBody() {
            return false;
        }
    }

    public class FarDistortionObject
    implements FarObject {
        private final Vector2 wormholePosition;
        private final Vector2 target;
        private final float stability;

        public FarDistortionObject(Vector2 wormholePosition, Vector2 target, float stability) {
            this.wormholePosition = wormholePosition;
            this.target = target;
            this.stability = stability;
        }

        public boolean shouldBeRemoved(SolGame game) {
            return false;
        }

        public SolObject toObject(SolGame game) {
            return new DistortionObject(this.wormholePosition, this.target, this.stability);
        }

        public void update(SolGame game) {
        }

        public float getRadius() {
            return 1.0f;
        }

        public Vector2 getPosition() {
            return this.wormholePosition;
        }

        public String toDebugString() {
            return "";
        }

        public boolean hasBody() {
            return false;
        }
    }
}

