/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.uiScreens;

import org.destinationsol.SolApplication;
import org.destinationsol.game.screens.RightPaneLayout;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.SolUiScreen;
import org.destinationsol.warp.research.systems.ResearchSystem;
import org.destinationsol.warp.research.uiScreens.ResearchUiScreen;

public class ResearchOverlayUiScreen
extends SolUiBaseScreen {
    private final ResearchUiScreen researchUiScreen;
    private final ResearchSystem researchSystem;
    private SolUiControl researchButtonControl;
    private float lastResearchValue;

    public ResearchOverlayUiScreen(ResearchSystem researchSystem) {
        this.researchSystem = researchSystem;
        this.researchUiScreen = new ResearchUiScreen(researchSystem);
        this.lastResearchValue = researchSystem.getResearchPoints();
    }

    public void onAdd(SolApplication application) {
        RightPaneLayout rightlayout = application.getLayouts().rightPaneLayout;
        this.researchButtonControl = new SolUiControl(rightlayout.buttonRect(5), true, new int[0]);
        this.researchButtonControl.setDisplayName("Research");
        this.controls.add(this.researchButtonControl);
    }

    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        float researchPoints = this.researchSystem.getResearchPoints();
        if (this.lastResearchValue < researchPoints) {
            this.researchButtonControl.enableWarn();
        }
        this.lastResearchValue = researchPoints;
        if (this.researchButtonControl.isJustOff()) {
            boolean screenShown = solApplication.getInputManager().isScreenOn((SolUiScreen)this.researchUiScreen);
            solApplication.getInputManager().setScreen(solApplication, (SolUiScreen)solApplication.getGame().getScreens().mainGameScreen);
            if (!screenShown) {
                solApplication.getInputManager().addScreen(solApplication, (SolUiScreen)this.researchUiScreen);
            }
        }
    }
}

