/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.warp.research.uiScreens;

import com.badlogic.gdx.math.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.Hero;
import org.destinationsol.menu.MenuLayout;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.warp.research.ResearchAction;
import org.destinationsol.warp.research.ResearchProvider;
import org.destinationsol.warp.research.systems.ResearchSystem;

public class ResearchUiScreen
extends SolUiBaseScreen {
    private static final float BUTTON_WIDTH = 0.86f;
    private static final float BUTTON_HEIGHT = 0.04f;
    private static final int BUTTONS_PER_PAGE = 8;
    private final ResearchSystem researchSystem;
    private Rectangle background;
    private SolUiControl researchTextControl;
    private Map<Integer, List<SolUiControl>> researchButtons;
    private SolUiControl previousButton;
    private SolUiControl nextButton;
    private SolUiControl sellResearchControl;
    private int actionsPage;

    public ResearchUiScreen(ResearchSystem researchSystem) {
        this.researchSystem = researchSystem;
    }

    public void onAdd(SolApplication application) {
        this.controls = new ArrayList();
        MenuLayout layout = application.getLayouts().menuLayout;
        this.background = new Rectangle(0.1f, 0.1f, 0.9f, 0.525f);
        this.researchTextControl = new SolUiControl(this.getButtonRectangle(0.105f, 0.105f), false, new int[0]);
        this.researchTextControl.setDisplayName("Research: " + Integer.toString((int)this.researchSystem.getResearchPoints()));
        this.controls.add(this.researchTextControl);
        this.researchButtons = new HashMap<Integer, List<SolUiControl>>();
        this.populateResearchButtons();
        float researchButtonsHeight = 0.33599997f;
        this.sellResearchControl = new SolUiControl(this.getButtonRectangle(0.105f, 0.2f + researchButtonsHeight + 0.04f), false, new int[0]);
        this.sellResearchControl.setDisplayName("Sell All Science");
        this.controls.add(this.sellResearchControl);
        this.previousButton = new SolUiControl(this.getHalfButtonRectangle(0.105f, 0.2f + researchButtonsHeight), false, new int[0]);
        this.previousButton.setDisplayName("Previous");
        this.controls.add(this.previousButton);
        this.nextButton = new SolUiControl(this.getHalfButtonRectangle(0.535f, 0.2f + researchButtonsHeight), false, new int[0]);
        this.nextButton.setDisplayName("Next");
        this.controls.add(this.nextButton);
        this.actionsPage = 0;
    }

    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(this.background, SolColor.UI_BG);
    }

    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        this.researchTextControl.setDisplayName("Research: " + Integer.toString((int)this.researchSystem.getResearchPoints()));
        this.researchButtons.values().forEach(buttons -> this.controls.removeAll((Collection<?>)buttons));
        this.researchButtons.clear();
        this.populateResearchButtons();
        this.sellResearchControl.setEnabled(solApplication.getGame().getScreens().mainGameScreen.talkControl.isEnabled() && (int)this.researchSystem.getResearchPoints() > 0);
        this.previousButton.setEnabled(this.actionsPage > 0);
        if (this.previousButton.isJustOff()) {
            --this.actionsPage;
        }
        this.nextButton.setEnabled(this.actionsPage < this.researchButtons.keySet().size() - 1);
        if (this.nextButton.isJustOff()) {
            ++this.actionsPage;
        }
        if (this.sellResearchControl.isJustOff()) {
            Hero hero = solApplication.getGame().getHero();
            this.researchSystem.sellResearchPoints(hero, this.researchSystem.getResearchPoints());
        }
    }

    private Rectangle getButtonRectangle(float x, float y) {
        return new Rectangle(x, y, 0.86f, 0.04f);
    }

    private Rectangle getHalfButtonRectangle(float x, float y) {
        return new Rectangle(x, y, 0.43f, 0.04f);
    }

    private void populateResearchButtons() {
        int actionNo = 0;
        for (ResearchProvider provider : ResearchSystem.getResearchProviders()) {
            for (ResearchAction action : provider.getDiscoveredActions()) {
                SolUiControl researchButton = new SolUiControl(this.getButtonRectangle(0.105f, 0.15f + (float)actionNo * 1.005f * 0.04f), false, new int[0]);
                researchButton.setDisplayName(action.getObjective());
                int pageNo = actionNo / 8;
                if (!this.researchButtons.containsKey(pageNo)) {
                    this.researchButtons.put(pageNo, new ArrayList());
                }
                this.researchButtons.get(pageNo).add(researchButton);
                ++actionNo;
            }
        }
        if (this.researchButtons.size() > 0) {
            this.controls.addAll((Collection)this.researchButtons.get(this.actionsPage));
        }
    }
}

