/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolMath;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.ResizeSubscriber;
import org.destinationsol.ui.UiDrawer;

public class CommonDrawer
implements ResizeSubscriber {
    private final SpriteBatch spriteBatch;
    private final BitmapFont font;
    private final float originalFontHeight;
    private final GlyphLayout layout;
    private final OrthographicCamera orthographicCamera;
    private final Viewport screenViewport;
    private DisplayDimensions displayDimensions = SolApplication.displayDimensions;

    CommonDrawer() {
        this.spriteBatch = new SpriteBatch();
        this.font = Assets.getFont("engine:main").getBitmapFont();
        this.originalFontHeight = this.font.getXHeight();
        this.layout = new GlyphLayout();
        this.orthographicCamera = new OrthographicCamera(1024.0f, 768.0f);
        this.screenViewport = new ScreenViewport((Camera)this.orthographicCamera);
        SolApplication.addResizeSubscriber(this);
    }

    public void setMatrix(Matrix4 matrix) {
        this.spriteBatch.setProjectionMatrix(matrix);
    }

    public void begin() {
        this.orthographicCamera.update();
        this.spriteBatch.begin();
    }

    public void end() {
        this.spriteBatch.end();
    }

    public void drawString(String s, float x, float y, float fontSize, boolean centered, Color col) {
        this.drawString(s, x, y, fontSize, UiDrawer.TextAlignment.CENTER, centered, col);
    }

    public void drawString(String s, float x, float y, float fontSize, UiDrawer.TextAlignment align, boolean verticalCentering, Color col) {
        if (s == null) {
            return;
        }
        this.font.setColor(col);
        this.font.getData().setScale(fontSize / this.originalFontHeight);
        this.layout.reset();
        this.layout.setText(this.font, (CharSequence)s);
        switch (align) {
            case LEFT: {
                break;
            }
            case CENTER: {
                x -= this.layout.width / 2.0f;
                break;
            }
            case RIGHT: {
                x -= this.layout.width;
            }
        }
        if (verticalCentering) {
            y -= this.layout.height / 2.0f;
        }
        this.font.draw((Batch)this.spriteBatch, this.layout, x, y);
    }

    public void draw(TextureRegion tr, float width, float height, float origX, float origY, float x, float y, float rot, Color tint) {
        this.setTint(tint);
        this.spriteBatch.draw(tr, x - origX, y - origY, origX, origY, width, height, 1.0f, 1.0f, rot);
    }

    private void setTint(Color tint) {
        this.spriteBatch.setColor(tint);
    }

    public void draw(TextureRegion tex, Rectangle rect, Color tint) {
        this.draw(tex, rect.width, rect.height, 0.0f, 0.0f, rect.x, rect.y, 0.0f, tint);
    }

    public void drawCircle(TextureRegion tex, Vector2 center, float radius, Color col, float width, float vh) {
        float relRad = radius / vh;
        int pointCount = (int)(160.0f * relRad);
        Vector2 position = SolMath.getVec();
        if (pointCount < 8) {
            pointCount = 8;
        }
        float lineLen = radius * (float)Math.PI * 2.0f / (float)pointCount;
        float angleStep = 360.0f / (float)pointCount;
        float angleStepH = angleStep / 2.0f;
        for (int i = 0; i < pointCount; ++i) {
            float angle = angleStep * (float)i;
            SolMath.fromAl(position, angle, radius);
            position.add(center);
            this.draw(tex, width, lineLen, 0.0f, 0.0f, position.x, position.y, angle + angleStepH, col);
        }
        SolMath.free(position);
    }

    public void drawLine(TextureRegion tex, float x, float y, float angle, float len, Color col, float width) {
        this.draw(tex, len, width, 0.0f, width / 2.0f, x, y, angle, col);
    }

    public void drawLine(TextureRegion tex, Vector2 startPoint, Vector2 endPoint, Color color, float width, boolean precise) {
        Vector2 endPointCopy = SolMath.getVec(endPoint);
        endPointCopy.sub(startPoint);
        this.drawLine(tex, startPoint.x, startPoint.y, SolMath.angle(endPointCopy), endPointCopy.len(), color, width);
        SolMath.free(endPointCopy);
    }

    public void dispose() {
        this.spriteBatch.dispose();
        this.font.dispose();
    }

    public SpriteBatch getSpriteBatch() {
        return this.spriteBatch;
    }

    public void setAdditive(boolean additive) {
        int dstFunc = additive ? 1 : 771;
        this.spriteBatch.setBlendFunction(770, dstFunc);
    }

    @Override
    public void resize() {
        this.screenViewport.update(this.displayDimensions.getWidth(), this.displayDimensions.getHeight(), true);
    }
}

