/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.SolApplication;
import org.destinationsol.game.FactionInfo;
import org.destinationsol.game.ObjectManager;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.UiDrawer;

public class FactionDisplay {
    private SolCam cam;
    private FactionInfo info;
    private boolean isPressed = false;

    public FactionDisplay(SolGame game, FactionInfo factionInfo) {
        this.cam = game.getCam();
        this.info = factionInfo;
    }

    public void drawFactionNames(SolGame game, UiDrawer uiDrawer, SolInputManager inputManager, ObjectManager objManager) {
        if (Gdx.input.isKeyJustPressed(54)) {
            boolean bl = this.isPressed = !this.isPressed;
        }
        if (this.isPressed && this.cam.getAngle() == 0.0f && !inputManager.isScreenOn(game.getScreens().mapScreen)) {
            for (SolObject obj : objManager.getObjects()) {
                if (!(obj instanceof SolShip)) continue;
                SolShip ship = (SolShip)obj;
                Vector2 drawPosition = this.cam.worldToScreen(ship);
                FactionDisplay factionDisplay = this;
                uiDrawer.drawString(ship.getFactionName(), drawPosition.x * SolApplication.displayDimensions.getRatio(), drawPosition.y - 0.1f, 1.0f, false, Color.valueOf((String)factionDisplay.info.getFactionColors().get(ship.getFactionID()).toString()));
            }
        }
    }
}

