/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.google.common.base.Enums;
import java.util.Arrays;
import org.destinationsol.IniReader;
import org.destinationsol.SolFileReader;
import org.destinationsol.menu.Resolution;
import org.destinationsol.menu.ResolutionProvider;

public class GameOptions {
    public static final String FILE_NAME = "settings.ini";
    public static final String DEFAULT_MOUSE_UP = "W";
    public static final String DEFAULT_MOUSE_DOWN = "S";
    public static final String DEFAULT_UP = "Up";
    public static final String DEFAULT_DOWN = "Down";
    public static final String DEFAULT_LEFT = "Left";
    public static final String DEFAULT_RIGHT = "Right";
    public static final String DEFAULT_SHOOT = "Space";
    public static final String DEFAULT_SHOOT2 = "L-Ctrl";
    public static final String DEFAULT_ABILITY = "L-Shift";
    public static final String DEFAULT_ESCAPE = "Escape";
    public static final String DEFAULT_MAP = "Tab";
    public static final String DEFAULT_INVENTORY = "I";
    public static final String DEFAULT_TALK = "T";
    public static final String DEFAULT_PAUSE = "P";
    public static final String DEFAULT_DROP = "D";
    public static final String DEFAULT_SELL = "S";
    public static final String DEFAULT_BUY = "B";
    public static final String DEFAULT_CHANGE_SHIP = "C";
    public static final String DEFAULT_HIRE_SHIP = "H";
    public static final String DEFAULT_MERCENARY_INTERACTION = "M";
    public static final String DEFAULT_FREE_CAMERA_MOVEMENT = "V";
    public static final int DEFAULT_AXIS_SHOOT = 1;
    public static final int DEFAULT_AXIS_SHOOT2 = 0;
    public static final int DEFAULT_AXIS_ABILITY = -1;
    public static final int DEFAULT_AXIS_LEFT_RIGHT = 2;
    public static final boolean DEFAULT_AXIS_LEFT_RIGHT_INVERTED = false;
    public static final int DEFAULT_AXIS_UP_DOWN = 5;
    public static final boolean DEFAULT_AXIS_UP_DOWN_INVERTED = false;
    public static final int DEFAULT_BUTTON_SHOOT = -1;
    public static final int DEFAULT_BUTTON_SHOOT2 = -1;
    public static final int DEFAULT_BUTTON_ABILITY = 14;
    public static final int DEFAULT_BUTTON_UP = -1;
    public static final int DEFAULT_BUTTON_DOWN = -1;
    public static final int DEFAULT_BUTTON_LEFT = -1;
    public static final int DEFAULT_BUTTON_RIGHT = -1;
    public static final int DEFAULT_MAP_SCROLL_SPEED = 10;
    public static final int DEFAULT_MOBILE_MAP_SCROLL_SPEED = 5;
    public int x;
    public int y;
    public boolean fullscreen;
    public ControlType controlType;
    public Volume sfxVolume;
    public Volume musicVolume;
    public boolean canSellEquippedItems;
    private String keyUpMouseName;
    private String keyDownMouseName;
    private String keyUpName;
    private String keyDownName;
    private String keyLeftName;
    private String keyRightName;
    private String keyShootName;
    private String keyShoot2Name;
    private String keyAbilityName;
    private String keyEscapeName;
    private String keyMapName;
    private String keyInventoryName;
    private String keyTalkName;
    private String keyPauseName;
    private String keyDropName;
    private String keySellMenuName;
    private String keyBuyMenuName;
    private String keyChangeShipMenuName;
    private String keyHireShipMenuName;
    private String keyMercenaryInteractionName;
    private String keyFreeCameraMovementName;
    private int controllerAxisShoot;
    private int controllerAxisShoot2;
    private int controllerAxisAbility;
    private int controllerAxisLeftRight;
    private boolean isControllerAxisLeftRightInverted;
    private int controllerAxisUpDown;
    private boolean isControllerAxisUpDownInverted;
    private int controllerButtonShoot;
    private int controllerButtonShoot2;
    private int controllerButtonAbility;
    private int controllerButtonLeft;
    private int controllerButtonRight;
    private int controllerButtonUp;
    private int controllerButtonDown;
    private int mapScrollSpeed;
    private ResolutionProvider resolutionProvider;

    public GameOptions(boolean mobile, SolFileReader solFileReader) {
        IniReader reader = new IniReader(FILE_NAME, solFileReader);
        this.x = reader.getInt("x", 1366);
        this.y = reader.getInt("y", 768);
        this.fullscreen = reader.getBoolean("fullscreen", false);
        this.controlType = mobile ? ControlType.KEYBOARD : (ControlType)((Object)Enums.getIfPresent(ControlType.class, (String)reader.getString("controlType", "MIXED")).or((Object)ControlType.MIXED));
        this.sfxVolume = (Volume)((Object)Enums.getIfPresent(Volume.class, (String)reader.getString("sfxVolume", "MAX")).or((Object)Volume.MAX));
        this.musicVolume = (Volume)((Object)Enums.getIfPresent(Volume.class, (String)reader.getString("musicVolume", "MAX")).or((Object)Volume.MAX));
        this.keyUpMouseName = reader.getString("keyUpMouse", DEFAULT_MOUSE_UP);
        this.keyDownMouseName = reader.getString("keyDownMouse", "S");
        this.keyUpName = reader.getString("keyUp", DEFAULT_UP);
        this.keyDownName = reader.getString("keyDown", DEFAULT_DOWN);
        this.keyLeftName = reader.getString("keyLeft", DEFAULT_LEFT);
        this.keyRightName = reader.getString("keyRight", DEFAULT_RIGHT);
        this.keyShootName = reader.getString("keyShoot", DEFAULT_SHOOT);
        this.keyShoot2Name = reader.getString("keyShoot2", DEFAULT_SHOOT2);
        this.keyAbilityName = reader.getString("keyAbility", DEFAULT_ABILITY);
        this.keyEscapeName = reader.getString("keyEscape", DEFAULT_ESCAPE);
        this.keyMapName = reader.getString("keyMap", DEFAULT_MAP);
        this.keyInventoryName = reader.getString("keyInventory", DEFAULT_INVENTORY);
        this.keyTalkName = reader.getString("keyTalk", DEFAULT_TALK);
        this.keyPauseName = reader.getString("keyPause", DEFAULT_PAUSE);
        this.keyDropName = reader.getString("keyDrop", DEFAULT_DROP);
        this.keySellMenuName = reader.getString("keySellMenu", "S");
        this.keyBuyMenuName = reader.getString("keyBuyMenu", DEFAULT_BUY);
        this.keyChangeShipMenuName = reader.getString("keyChangeShipMenu", DEFAULT_CHANGE_SHIP);
        this.keyHireShipMenuName = reader.getString("keyHireShipMenu", DEFAULT_HIRE_SHIP);
        this.keyMercenaryInteractionName = reader.getString("keyMercenaryInteraction", DEFAULT_MERCENARY_INTERACTION);
        this.keyFreeCameraMovementName = reader.getString("keyFreeCameraMovement", DEFAULT_FREE_CAMERA_MOVEMENT);
        this.controllerAxisShoot = reader.getInt("controllerAxisShoot", 1);
        this.controllerAxisShoot2 = reader.getInt("controllerAxisShoot2", 0);
        this.controllerAxisAbility = reader.getInt("controllerAxisAbility", -1);
        this.controllerAxisLeftRight = reader.getInt("controllerAxisLeftRight", 2);
        this.isControllerAxisLeftRightInverted = reader.getBoolean("isControllerAxisLeftRightInverted", false);
        this.controllerAxisUpDown = reader.getInt("controllerAxisUpDown", 5);
        this.isControllerAxisUpDownInverted = reader.getBoolean("isControllerAxisUpDownInverted", false);
        this.controllerButtonShoot = reader.getInt("controllerButtonShoot", -1);
        this.controllerButtonShoot2 = reader.getInt("controllerButtonShoot2", -1);
        this.controllerButtonAbility = reader.getInt("controllerButtonAbility", 14);
        this.controllerButtonLeft = reader.getInt("controllerButtonLeft", -1);
        this.controllerButtonRight = reader.getInt("controllerButtonRight", -1);
        this.controllerButtonUp = reader.getInt("controllerButtonUp", -1);
        this.controllerButtonDown = reader.getInt("controllerButtonDown", -1);
        this.canSellEquippedItems = reader.getBoolean("canSellEquippedItems", false);
        this.mapScrollSpeed = reader.getInt("mapScrollSpeed", mobile ? 5 : 10);
    }

    public void advanceResolution() {
        if (this.resolutionProvider == null) {
            this.resolutionProvider = new ResolutionProvider(Arrays.asList(Gdx.graphics.getDisplayModes()));
        }
        Resolution nextResolution = this.resolutionProvider.increase();
        this.x = nextResolution.getWidth();
        this.y = nextResolution.getHeight();
        this.save();
    }

    public void advanceControlType(boolean mobile) {
        this.controlType = this.controlType.nextType(mobile);
        this.save();
    }

    public void advanceFullscreen() {
        this.fullscreen = !this.fullscreen;
        this.save();
    }

    public void advanceSoundVolMul() {
        this.sfxVolume = this.sfxVolume.advance();
        this.save();
    }

    public void advanceMusicVolMul() {
        this.musicVolume = this.musicVolume.advance();
        this.save();
    }

    public void advanceMapScrollSpeed() {
        ++this.mapScrollSpeed;
        if (this.mapScrollSpeed > 15) {
            this.mapScrollSpeed = 1;
        }
    }

    public void save() {
        IniReader.write(FILE_NAME, new Object[]{"x", this.x, "y", this.y, "fullscreen", this.fullscreen, "controlType", this.controlType, "sfxVolume", this.sfxVolume, "musicVolume", this.musicVolume, "canSellEquippedItems", this.canSellEquippedItems, "keyUpMouse", this.getKeyUpMouseName(), "keyDownMouse", this.getKeyDownMouseName(), "keyUp", this.getKeyUpName(), "keyDown", this.keyDownName, "keyLeft", this.keyLeftName, "keyRight", this.keyRightName, "keyShoot", this.keyShootName, "keyShoot2", this.getKeyShoot2Name(), "keyAbility", this.getKeyAbilityName(), "keyEscape", this.getKeyEscapeName(), "keyMap", this.keyMapName, "keyInventory", this.keyInventoryName, "keyTalk", this.getKeyTalkName(), "keyPause", this.getKeyPauseName(), "keyDrop", this.getKeyDropName(), "keySellMenu", this.getKeySellMenuName(), "keyBuyMenu", this.getKeyBuyMenuName(), "keyChangeShipMenu", this.getKeyChangeShipMenuName(), "keyHireShipMenu", this.getKeyHireShipMenuName(), "controllerAxisShoot", this.getControllerAxisShoot(), "controllerAxisShoot2", this.getControllerAxisShoot2(), "controllerAxisAbility", this.getControllerAxisAbility(), "controllerAxisLeftRight", this.getControllerAxisLeftRight(), "isControllerAxisLeftRightInverted", this.isControllerAxisLeftRightInverted(), "controllerAxisUpDown", this.getControllerAxisUpDown(), "isControllerAxisUpDownInverted", this.isControllerAxisUpDownInverted(), "controllerButtonShoot", this.getControllerButtonShoot(), "controllerButtonShoot2", this.getControllerButtonShoot2(), "controllerButtonAbility", this.getControllerButtonAbility(), "controllerButtonLeft", this.getControllerButtonLeft(), "controllerButtonRight", this.getControllerButtonRight(), "controllerButtonUp", this.getControllerButtonUp(), "controllerButtonDown", this.getControllerButtonDown(), "mapScrollSpeed", this.getMapScrollSpeed()});
    }

    public int getKeyUpMouse() {
        return Input.Keys.valueOf((String)this.getKeyUpMouseName());
    }

    public int getKeyDownMouse() {
        return Input.Keys.valueOf((String)this.getKeyDownMouseName());
    }

    public String getKeyUpMouseName() {
        return this.keyUpMouseName;
    }

    public void setKeyUpMouseName(String keyUpMouseName) {
        this.keyUpMouseName = keyUpMouseName;
    }

    public String getKeyDownMouseName() {
        return this.keyDownMouseName;
    }

    public void setKeyDownMouseName(String keyDownMouseName) {
        this.keyDownMouseName = keyDownMouseName;
    }

    public int getKeyUp() {
        return Input.Keys.valueOf((String)this.getKeyUpName());
    }

    public String getKeyUpName() {
        return this.keyUpName;
    }

    public void setKeyUpName(String keyUpName) {
        this.keyUpName = keyUpName;
    }

    public int getKeyDown() {
        return Input.Keys.valueOf((String)this.keyDownName);
    }

    public String getKeyDownName() {
        return this.keyDownName;
    }

    public void setKeyDownName(String keyDownName) {
        this.keyDownName = keyDownName;
    }

    public int getKeyLeft() {
        return Input.Keys.valueOf((String)this.keyLeftName);
    }

    public String getKeyLeftName() {
        return this.keyLeftName;
    }

    public void setKeyLeftName(String keyLeftName) {
        this.keyLeftName = keyLeftName;
    }

    public int getKeyRight() {
        return Input.Keys.valueOf((String)this.keyRightName);
    }

    public String getKeyRightName() {
        return this.keyRightName;
    }

    public void setKeyRightName(String keyRightName) {
        this.keyRightName = keyRightName;
    }

    public int getKeyShoot() {
        return Input.Keys.valueOf((String)this.keyShootName);
    }

    public String getKeyShootName() {
        return this.keyShootName;
    }

    public void setKeyShootName(String keyShootName) {
        this.keyShootName = keyShootName;
    }

    public int getKeyShoot2() {
        return Input.Keys.valueOf((String)this.getKeyShoot2Name());
    }

    public String getKeyShoot2Name() {
        return this.keyShoot2Name;
    }

    public void setKeyShoot2Name(String keyShoot2Name) {
        this.keyShoot2Name = keyShoot2Name;
    }

    public int getKeyEquip() {
        return Input.Keys.valueOf((String)this.keyShootName);
    }

    public String getKeyEquipName() {
        return this.getKeyShootName();
    }

    public int getKeyEquip2() {
        return Input.Keys.valueOf((String)this.getKeyShoot2Name());
    }

    public int getKeyAbility() {
        return Input.Keys.valueOf((String)this.getKeyAbilityName());
    }

    public String getKeyAbilityName() {
        return this.keyAbilityName;
    }

    public void setKeyAbilityName(String keyAbilityName) {
        this.keyAbilityName = keyAbilityName;
    }

    public int getKeyEscape() {
        return Input.Keys.valueOf((String)this.getKeyEscapeName());
    }

    public String getKeyEscapeName() {
        return this.keyEscapeName;
    }

    public void setKeyEscapeName(String keyEscapeName) {
        this.keyEscapeName = keyEscapeName;
    }

    public int getKeyMenu() {
        return this.getKeyEscape();
    }

    public int getKeyClose() {
        return this.getKeyEscape();
    }

    public String getKeyCloseName() {
        return this.getKeyEscapeName();
    }

    public int getKeyBuyItem() {
        return this.getKeyShoot();
    }

    public String getKeyBuyItemName() {
        return this.getKeyShootName();
    }

    public int getKeySellItem() {
        return this.getKeyShoot();
    }

    public int getKeyHireShip() {
        return this.getKeyShoot();
    }

    public int getKeyChangeShip() {
        return this.getKeyShoot();
    }

    public int getKeyZoomIn() {
        return this.getKeyUp();
    }

    public String getKeyZoomInName() {
        return this.getKeyUpName();
    }

    public int getKeyZoomOut() {
        return this.getKeyDown();
    }

    public int getKeyMap() {
        return Input.Keys.valueOf((String)this.keyMapName);
    }

    public String getKeyMapName() {
        return this.keyMapName;
    }

    public void setKeyMapName(String keyMapName) {
        this.keyMapName = keyMapName;
    }

    public int getKeyInventory() {
        return Input.Keys.valueOf((String)this.keyInventoryName);
    }

    public String getKeyInventoryName() {
        return this.keyInventoryName;
    }

    public void setKeyInventoryName(String keyInventoryName) {
        this.keyInventoryName = keyInventoryName;
    }

    public int getKeyMercenaryInteraction() {
        return Input.Keys.valueOf((String)this.keyMercenaryInteractionName);
    }

    public String getKeyMercenaryInterationName() {
        return this.keyMercenaryInteractionName;
    }

    public void setKeyMercenaryInteractionName(String keyMercenaryInteractionName) {
        this.keyMercenaryInteractionName = keyMercenaryInteractionName;
    }

    public int getKeyFreeCameraMovement() {
        return Input.Keys.valueOf((String)this.getKeyFreeCameraMovementName());
    }

    public String getKeyFreeCameraMovementName() {
        return this.keyFreeCameraMovementName;
    }

    public void setKeyFreeCameraMovementName(String keyFreeCameraMovementName) {
        this.keyFreeCameraMovementName = keyFreeCameraMovementName;
    }

    public int getKeyTalk() {
        return Input.Keys.valueOf((String)this.getKeyTalkName());
    }

    public String getKeyTalkName() {
        return this.keyTalkName;
    }

    public void setKeyTalkName(String keyTalkName) {
        this.keyTalkName = keyTalkName;
    }

    public int getKeyPause() {
        return Input.Keys.valueOf((String)this.getKeyPauseName());
    }

    public String getKeyPauseName() {
        return this.keyPauseName;
    }

    public void setKeyPauseName(String keyPauseName) {
        this.keyPauseName = keyPauseName;
    }

    public int getKeyDrop() {
        return Input.Keys.valueOf((String)this.getKeyDropName());
    }

    public String getKeyDropName() {
        return this.keyDropName;
    }

    public void setKeyDropName(String keyDropName) {
        this.keyDropName = keyDropName;
    }

    public int getKeySellMenu() {
        return Input.Keys.valueOf((String)this.getKeySellMenuName());
    }

    public String getKeySellMenuName() {
        return this.keySellMenuName;
    }

    public void setKeySellMenuName(String keySellMenuName) {
        this.keySellMenuName = keySellMenuName;
    }

    public int getKeyBuyMenu() {
        return Input.Keys.valueOf((String)this.getKeyBuyMenuName());
    }

    public String getKeyBuyMenuName() {
        return this.keyBuyMenuName;
    }

    public void setKeyBuyMenuName(String keyBuyMenuName) {
        this.keyBuyMenuName = keyBuyMenuName;
    }

    public int getKeyChangeShipMenu() {
        return Input.Keys.valueOf((String)this.getKeyChangeShipMenuName());
    }

    public String getKeyChangeShipMenuName() {
        return this.keyChangeShipMenuName;
    }

    public void setKeyChangeShipMenuName(String keyChangeShipMenuName) {
        this.keyChangeShipMenuName = keyChangeShipMenuName;
    }

    public int getKeyHireShipMenu() {
        return Input.Keys.valueOf((String)this.getKeyHireShipMenuName());
    }

    public String getKeyHireShipMenuName() {
        return this.keyHireShipMenuName;
    }

    public void setKeyHireShipMenuName(String keyHireShipMenuName) {
        this.keyHireShipMenuName = keyHireShipMenuName;
    }

    public int getControllerAxisShoot() {
        return this.controllerAxisShoot;
    }

    public void setControllerAxisShoot(int controllerAxisShoot) {
        this.controllerAxisShoot = controllerAxisShoot;
    }

    public int getControllerAxisShoot2() {
        return this.controllerAxisShoot2;
    }

    public void setControllerAxisShoot2(int controllerAxisShoot2) {
        this.controllerAxisShoot2 = controllerAxisShoot2;
    }

    public int getControllerAxisAbility() {
        return this.controllerAxisAbility;
    }

    public void setControllerAxisAbility(int controllerAxisAbility) {
        this.controllerAxisAbility = controllerAxisAbility;
    }

    public int getControllerAxisLeftRight() {
        return this.controllerAxisLeftRight;
    }

    public void setControllerAxisLeftRight(int controllerAxisLeftRight) {
        this.controllerAxisLeftRight = controllerAxisLeftRight;
    }

    public int getControllerAxisUpDown() {
        return this.controllerAxisUpDown;
    }

    public void setControllerAxisUpDown(int controllerAxisUpDown) {
        this.controllerAxisUpDown = controllerAxisUpDown;
    }

    public int getControllerButtonShoot() {
        return this.controllerButtonShoot;
    }

    public void setControllerButtonShoot(int controllerButtonShoot) {
        this.controllerButtonShoot = controllerButtonShoot;
    }

    public int getControllerButtonShoot2() {
        return this.controllerButtonShoot2;
    }

    public void setControllerButtonShoot2(int controllerButtonShoot2) {
        this.controllerButtonShoot2 = controllerButtonShoot2;
    }

    public int getControllerButtonAbility() {
        return this.controllerButtonAbility;
    }

    public void setControllerButtonAbility(int controllerButtonAbility) {
        this.controllerButtonAbility = controllerButtonAbility;
    }

    public int getControllerButtonLeft() {
        return this.controllerButtonLeft;
    }

    public void setControllerButtonLeft(int controllerButtonLeft) {
        this.controllerButtonLeft = controllerButtonLeft;
    }

    public int getControllerButtonRight() {
        return this.controllerButtonRight;
    }

    public void setControllerButtonRight(int controllerButtonRight) {
        this.controllerButtonRight = controllerButtonRight;
    }

    public int getControllerButtonUp() {
        return this.controllerButtonUp;
    }

    public void setControllerButtonUp(int controllerButtonUp) {
        this.controllerButtonUp = controllerButtonUp;
    }

    public boolean isControllerAxisLeftRightInverted() {
        return this.isControllerAxisLeftRightInverted;
    }

    public boolean isControllerAxisUpDownInverted() {
        return this.isControllerAxisUpDownInverted;
    }

    public void setIsControllerAxisLeftRightInverted(boolean isControllerAxisLeftRightInverted) {
        this.isControllerAxisLeftRightInverted = isControllerAxisLeftRightInverted;
    }

    public void setIsControllerAxisUpDownInverted(boolean isControllerAxisUpDownInverted) {
        this.isControllerAxisUpDownInverted = isControllerAxisUpDownInverted;
    }

    public int getControllerButtonDown() {
        return this.controllerButtonDown;
    }

    public void setControllerButtonDown(int controllerButtonDown) {
        this.controllerButtonDown = controllerButtonDown;
    }

    public int getMapScrollSpeed() {
        return this.mapScrollSpeed;
    }

    public void setMapScrollSpeed(int mapScrollSpeed) {
        this.mapScrollSpeed = mapScrollSpeed;
    }

    public static enum ControlType {
        KEYBOARD("Keyboard"),
        MIXED("KB + Mouse"),
        MOUSE("Mouse"),
        CONTROLLER("Controller");

        private String humanName;

        private ControlType(String humanName) {
            this.humanName = humanName;
        }

        public String getHumanName() {
            return this.humanName;
        }

        public ControlType nextType(boolean isMobile) {
            switch (this) {
                case MIXED: {
                    return CONTROLLER;
                }
                case CONTROLLER: 
                case MOUSE: {
                    return KEYBOARD;
                }
            }
            return isMobile ? MOUSE : MIXED;
        }
    }

    public static enum Volume {
        OFF("Off", 0.0f),
        LOW("Low", 0.25f),
        MEDIUM("Medium", 0.5f),
        HIGH("High", 0.75f),
        MAX("Max", 1.0f);

        private final String name;
        private final float volume;

        private Volume(String name, float volume) {
            this.name = name;
            this.volume = volume;
        }

        public String getName() {
            return this.name;
        }

        public float getVolume() {
            return this.volume;
        }

        public Volume advance() {
            switch (this) {
                case OFF: {
                    return LOW;
                }
                case LOW: {
                    return MEDIUM;
                }
                case MEDIUM: {
                    return HIGH;
                }
                case HIGH: {
                    return MAX;
                }
                case MAX: {
                    return OFF;
                }
            }
            return MAX;
        }
    }
}

