/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol;

import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.destinationsol.SolFileReader;
import org.destinationsol.game.SaveManager;

public class IniReader {
    private final HashMap<String, String> values = new HashMap();

    public IniReader(String fileName, SolFileReader reader) {
        List<String> lines = reader != null ? reader.read(fileName) : this.fileToLines(fileName);
        this.initValueMap(lines);
    }

    public IniReader(BufferedReader reader) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initValueMap(lines);
    }

    public static void write(String fileName, Object ... keysVals) {
        boolean second = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object value : keysVals) {
            stringBuilder.append(value.toString());
            stringBuilder.append(second ? (char)'\n' : '=');
            second = !second;
        }
        String path = SaveManager.getResourcePath(fileName);
        FileHandle file = new FileHandle(new File(path));
        file.writeString(stringBuilder.toString(), false);
    }

    private void initValueMap(List<String> lines) {
        for (String line : lines) {
            String[] sides;
            int commentStart = line.indexOf(35);
            if (commentStart >= 0) {
                line = line.substring(0, commentStart);
            }
            if ((sides = line.split("=")).length < 2) continue;
            String key = sides[0].trim();
            String val = sides[1].trim();
            this.values.put(key, val);
        }
    }

    private List<String> fileToLines(String fileName) {
        String path = SaveManager.getResourcePath(fileName);
        FileHandle file = new FileHandle(new File(path));
        ArrayList<String> res = new ArrayList<String>();
        if (!file.exists()) {
            return res;
        }
        Collections.addAll(res, file.readString().split("\n"));
        return res;
    }

    public String getString(String key, String defaultValue) {
        Optional<String> stringOptional = Optional.ofNullable(this.values.get(key));
        return stringOptional.orElse(defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        Optional<String> stringOptional = Optional.ofNullable(this.values.get(key));
        try {
            return stringOptional.map(Integer::parseInt).orElse(defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Optional<String> stringOptional = Optional.ofNullable(this.values.get(key));
        Optional<Boolean> booleanOptional = stringOptional.filter(s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")).map(s -> s.equalsIgnoreCase("true"));
        return booleanOptional.orElse(defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        Optional<String> stringOptional = Optional.ofNullable(this.values.get(key));
        try {
            return stringOptional.map(Float::parseFloat).orElse(Float.valueOf(defaultValue)).floatValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

