/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.physics.box2d.Box2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.destinationsol.CommonDrawer;
import org.destinationsol.FactionDisplay;
import org.destinationsol.GameOptions;
import org.destinationsol.assets.AssetHelper;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.music.OggMusicManager;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.entitysystem.ComponentSystemManager;
import org.destinationsol.entitysystem.EntitySystemManager;
import org.destinationsol.entitysystem.SerialisationManager;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.FactionInfo;
import org.destinationsol.game.SaveManager;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.WorldConfig;
import org.destinationsol.game.console.adapter.ParameterAdapterManager;
import org.destinationsol.game.context.Context;
import org.destinationsol.game.context.internal.ContextImpl;
import org.destinationsol.menu.MenuScreens;
import org.destinationsol.menu.background.MenuBackgroundManager;
import org.destinationsol.modules.ModuleManager;
import org.destinationsol.ui.DebugCollector;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.ResizeSubscriber;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolLayouts;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.util.FramerateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terasology.gestalt.entitysystem.component.Component;
import org.terasology.gestalt.entitysystem.component.management.ComponentManager;
import org.terasology.gestalt.module.sandbox.API;

@API
public class SolApplication
implements ApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(SolApplication.class);
    private final float targetFPS;
    private ModuleManager moduleManager;
    private EntitySystemManager entitySystemManager;
    private OggMusicManager musicManager;
    private OggSoundManager soundManager;
    private SolInputManager inputManager;
    private MenuBackgroundManager menuBackgroundManager;
    private UiDrawer uiDrawer;
    private FactionDisplay factionDisplay;
    private MenuScreens menuScreens;
    private SolLayouts layouts;
    private GameOptions options;
    private CommonDrawer commonDrawer;
    private String fatalErrorMsg;
    private String fatalErrorTrace;
    private SolGame solGame;
    private ParameterAdapterManager parameterAdapterManager;
    private Context context;
    private WorldConfig worldConfig;
    public static DisplayDimensions displayDimensions;
    private float timeAccumulator = 0.0f;
    private boolean isMobile;
    private static Set<ResizeSubscriber> resizeSubscribers;

    public SolApplication(ModuleManager moduleManager, float targetFPS) {
        Box2D.init();
        this.moduleManager = moduleManager;
        this.targetFPS = targetFPS;
        resizeSubscribers = new HashSet<ResizeSubscriber>();
    }

    public void create() {
        this.context = new ContextImpl();
        this.context.put(SolApplication.class, this);
        this.context.put(ModuleManager.class, this.moduleManager);
        this.worldConfig = new WorldConfig();
        boolean bl = this.isMobile = Gdx.app.getType() == Application.ApplicationType.Android || Gdx.app.getType() == Application.ApplicationType.iOS;
        if (this.isMobile) {
            DebugOptions.read(null);
        }
        this.options = new GameOptions(this.isMobile(), null);
        ComponentManager componentManager = new ComponentManager();
        AssetHelper helper = new AssetHelper();
        helper.init(this.moduleManager.getEnvironment(), componentManager, this.isMobile);
        Assets.initialize(helper);
        this.entitySystemManager = new EntitySystemManager(this.moduleManager.getEnvironment(), componentManager);
        this.context.put(EntitySystemManager.class, this.entitySystemManager);
        this.context.put(ComponentSystemManager.class, new ComponentSystemManager(this.moduleManager.getEnvironment(), this.context));
        Iterator componentClasses = this.moduleManager.getEnvironment().getSubtypesOf(Component.class).iterator();
        SerialisationManager serialisationManager = new SerialisationManager(SaveManager.getResourcePath("entity_store.dat"), this.entitySystemManager.getEntityManager(), componentClasses.hasNext() ? ((Class)componentClasses.next()).getClassLoader() : null);
        this.context.put(SerialisationManager.class, serialisationManager);
        logger.info("\n\n ------------------------------------------------------------ \n");
        this.moduleManager.printAvailableModules();
        this.musicManager = new OggMusicManager(this.options);
        this.soundManager = new OggSoundManager(this.context);
        this.inputManager = new SolInputManager(this.soundManager, this.context);
        this.musicManager.playMusic("menu", this.options);
        displayDimensions = new DisplayDimensions(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.commonDrawer = new CommonDrawer();
        this.uiDrawer = new UiDrawer(this.commonDrawer);
        this.layouts = new SolLayouts();
        this.menuBackgroundManager = new MenuBackgroundManager(displayDimensions);
        this.menuScreens = new MenuScreens(this.layouts, this.isMobile(), this.options);
        this.inputManager.setScreen(this, this.menuScreens.main);
        this.parameterAdapterManager = ParameterAdapterManager.createCore(this);
    }

    public void resize(int newWidth, int newHeight) {
        displayDimensions.set(newWidth, newHeight);
        for (ResizeSubscriber resizeSubscriber : resizeSubscribers) {
            resizeSubscriber.resize();
        }
    }

    public void render() {
        block3: {
            this.timeAccumulator += Gdx.graphics.getDeltaTime();
            while (this.timeAccumulator > 0.016666668f) {
                this.safeUpdate();
                this.timeAccumulator -= 0.016666668f;
            }
            FramerateLimiter.synchronizeFPS(Math.round(this.targetFPS));
            try {
                this.draw();
            }
            catch (Throwable t) {
                logger.error("Fatal Error:", t);
                this.fatalErrorMsg = "A fatal error occurred:\n" + t.getMessage();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                this.fatalErrorTrace = sw.toString();
                if (this.isMobile) break block3;
                throw t;
            }
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    private void safeUpdate() {
        block3: {
            if (this.fatalErrorMsg != null) {
                return;
            }
            try {
                this.update();
            }
            catch (Throwable t) {
                logger.error("Fatal Error:", t);
                this.fatalErrorMsg = "A fatal error occurred:\n" + t.getMessage();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                this.fatalErrorTrace = sw.toString();
                if (this.isMobile) break block3;
                throw t;
            }
        }
    }

    private void update() {
        DebugCollector.update();
        if (DebugOptions.SHOW_FPS) {
            DebugCollector.debug("Fps", Gdx.graphics.getFramesPerSecond());
        }
        this.inputManager.update(this);
        if (this.solGame != null) {
            this.solGame.update();
        }
        SolMath.checkVectorsTaken(null);
    }

    private void draw() {
        Gdx.gl.glClear(16384);
        this.commonDrawer.begin();
        if (this.solGame != null) {
            this.solGame.draw();
        }
        this.uiDrawer.updateMtx();
        this.inputManager.draw(this.uiDrawer, this);
        if (this.solGame != null) {
            this.solGame.drawDebugUi(this.uiDrawer);
            this.factionDisplay.drawFactionNames(this.solGame, this.uiDrawer, this.inputManager, this.solGame.getObjectManager());
        }
        if (this.fatalErrorMsg != null) {
            this.uiDrawer.draw(UiDrawer.whiteTexture, displayDimensions.getRatio(), 0.5f, 0.0f, 0.0f, 0.0f, 0.25f, 0.0f, SolColor.UI_BG);
            this.uiDrawer.drawString(this.fatalErrorMsg, displayDimensions.getRatio(), 0.5f, 1.0f, true, SolColor.WHITE);
            this.uiDrawer.drawString(this.fatalErrorTrace, 0.2f * displayDimensions.getRatio(), 0.6f, 0.5f, false, SolColor.WHITE);
        }
        DebugCollector.draw(this.uiDrawer);
        if (this.solGame == null) {
            this.uiDrawer.drawString("v2.0.0", 0.01f, 0.974f, 0.5f, UiDrawer.TextAlignment.LEFT, false, SolColor.WHITE);
        }
        this.commonDrawer.end();
    }

    public void loadGame(boolean tut, String shipName, boolean isNewGame) {
        if (this.solGame != null) {
            throw new AssertionError((Object)"Starting a new game with unfinished current one");
        }
        this.inputManager.setScreen(this, this.menuScreens.loading);
        this.menuScreens.loading.setMode(tut, shipName, isNewGame);
    }

    public void play(boolean tut, String shipName, boolean isNewGame) {
        if (isNewGame) {
            this.beforeNewGame();
        } else {
            this.beforeLoadGame();
        }
        this.context.get(ComponentSystemManager.class).preBegin();
        FactionInfo factionInfo = new FactionInfo();
        this.solGame = new SolGame(shipName, tut, isNewGame, this.commonDrawer, this.context, this.worldConfig);
        this.factionDisplay = new FactionDisplay(this.solGame, factionInfo);
        this.inputManager.setScreen(this, this.solGame.getScreens().mainGameScreen);
    }

    public SolInputManager getInputManager() {
        return this.inputManager;
    }

    public MenuScreens getMenuScreens() {
        return this.menuScreens;
    }

    public void dispose() {
        this.commonDrawer.dispose();
        if (this.solGame != null) {
            this.solGame.onGameEnd(this.context);
        }
        this.inputManager.dispose();
    }

    public SolGame getGame() {
        return this.solGame;
    }

    public ParameterAdapterManager getParameterAdapterManager() {
        return this.parameterAdapterManager;
    }

    public SolLayouts getLayouts() {
        return this.layouts;
    }

    public void finishGame() {
        this.solGame.onGameEnd(this.context);
        this.solGame = null;
        this.inputManager.setScreen(this, this.menuScreens.main);
    }

    public boolean isMobile() {
        return DebugOptions.EMULATE_MOBILE || this.isMobile;
    }

    public GameOptions getOptions() {
        return this.options;
    }

    public OggMusicManager getMusicManager() {
        return this.musicManager;
    }

    public OggSoundManager getSoundManager() {
        return this.soundManager;
    }

    public MenuBackgroundManager getMenuBackgroundManager() {
        return this.menuBackgroundManager;
    }

    private void beforeNewGame() {
        this.worldConfig.setSeed(System.currentTimeMillis());
        SolRandom.setSeed(this.worldConfig.getSeed());
        FactionInfo.clearValues();
        this.worldConfig.setNumberOfSystems(this.getMenuScreens().newShip.getNumberOfSystems());
    }

    private void beforeLoadGame() {
        try {
            this.context.get(SerialisationManager.class).deserialise();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WorldConfig config = SaveManager.loadWorld();
        if (config != null) {
            this.worldConfig = config;
            SolRandom.setSeed(this.worldConfig.getSeed());
        }
    }

    public static void addResizeSubscriber(ResizeSubscriber resizeSubscriber) {
        resizeSubscribers.add(resizeSubscriber);
    }
}

